#include <stdio.h>
#include <assert.h>

/* Renvoie le terme après x dans une suite de Syracuse.
   x doit être positif */
long int suivant(long int x){
	assert(x >= 0);
	if (x % 2 == 0){
		return x / 2;
	} else {
		return 3*x + 1;
	}
}

/* Renvoie le n-ème terme de la suite de Syracuse de x.
   x et n doivent être positifs */
long int syracuse(long int x, int n){
	assert(x >= 0);
	assert(n >= 0);
	int u = x;
	for (int i = 0; i < n; i++){
		u = suivant(u);
	}
	return u;
}

/* Renvoie le plus petit n tel que, en notant (u_k) la suite
   de syracuse de x, u_n = 0 */
long int temps_de_vol(long int x){
	assert(x >= 0);
	if (x == 1){
		return 0;
	}
	return 1 + temps_de_vol(suivant(x));
}

/* Renvoie l'entier entre 1 et N ayant le plus long
   temps de vol.*/
long int plus_long_vol(long int N){
	assert(N >= 1);
	int plus_long_temps = 0;
	int candidat = 1; // x tel que temps_de_vol(x) = plus_long_temps
	for (int i = 1; i <= N; ++i){
		int temps_i = temps_de_vol(i); 
		if (temps_i > plus_long_temps){
			// avoir stocké le temps de vol dans une variable temps_i
			// évite d'avoir à le recalculer ici !
			plus_long_temps = temps_i; 
			candidat = i;
		}
	}
	return candidat;
}

// Fonctions pour répondre aux questions
void repondre_Q2(long int x, int n){
	printf("x = %ld, n = %d: syracuse(x, n) = %ld\n", x, n, syracuse(x, n));
}

void repondre_Q3(long int x){
	printf("x = %ld: temps_de_vol(x) = %ld\n", x, temps_de_vol(x));
}

void repondre_Q4(long int N){
	printf("N = %ld: plus_long_vol(N) = %ld\n", N, plus_long_vol(N));
}


int main(){
	// tests (on vérifie les valeurs du tableau donné dans l'énoncé)
	assert(suivant(5) == 16);
	assert(suivant(16) == 8);
	assert(suivant(3) == 10);
	assert(suivant(2) == 1);
	assert(suivant(1) == 4);

	assert(syracuse(1, 0) == 1);
	assert(syracuse(1, 7) == 4);
	assert(syracuse(5, 4) == 2);
	assert(syracuse(6, 4) == 16);

	assert(temps_de_vol(1) == 0);
	assert(temps_de_vol(5) == 5);
	assert(temps_de_vol(6) == 8);
	assert(temps_de_vol(2) == 1);

	assert(plus_long_vol(4) == 3);

	printf("TESTS OK\n");

	// réponses aux questions
	repondre_Q2(9, 6);
	repondre_Q2(77, 128);
	repondre_Q2(1023, 729);
	repondre_Q2(1234567, 52697);

	repondre_Q3(1);	
	repondre_Q3(26);	
	repondre_Q3(27);	
	repondre_Q3(28);	
	repondre_Q3(77030);	
	repondre_Q3(77031);	

	// boucle qui teste N = 10, 100, 1000, ... jusqu'à 10000000
	for (long int N = 10; N <= 10000000; N = N * 10) {
		repondre_Q4(N);
	}
}