#include <stdio.h>
#include <stdbool.h>
#include <assert.h>

/* Affiche la k-ème ligne de l'escalier, composée
   de 2k+1 '-' puis un '|'' */
void affiche_ligne(int k){
	assert(k >= 0);
	for (int i = 0; i < 2*k+1; ++i){
		printf("-");
	}
	printf("|\n");
}

/* Affiche un escalier de n marches.
Exemple: escalier(5) affiche:
-|
---|
-----|
-------|
---------|
*/
void affiche_escalier(int n){
	assert(n >= 0);
	for (int i = 0; i < n; ++i){
		affiche_ligne(i);
	}
}

int main(){
	int n;
	printf("Entrez un entier:\n");
	scanf("%d", &n);
	affiche_escalier(n);

	return 0;
}