#include <stdio.h>



// Q1
/* Affiche les n premiers entiers naturels, dans l'ordre
   décroissant. (n >= 0) */
void decompte(int n){
	assert(n >= 0);
	if (n == 0){ 
		// ne rien faire
	} else {
		printf("%d\n", n-1);
		decompte(n-1);
	}
}

// Q2
/* Affiche les n premiers entiers naturels, dans l'ordre
   croissant. (n >= 0) */
void compte(int n){
	assert(n >= 0);
	if (n == 0){ 
		// ne rien faire
	} else {
		compte(n-1);
		printf("%d\n", n-1);
	}
}

// Q3
/* Affiche les chiffres de n sur une ligne chacun,
   de la plus grande puissance de 10 à la plus petite */
void chiffres(int n){
	// cas particulier: si n < 0, on commence par afficher
	// un - et on traite |n| ensuite
	if (n < 0){
		printf("-\n");
		chiffres(-n);
	} else if (n == 0) { 
		// ne rien faire
	} else {
		// enlever le chiffre des unités,
		// et recommencer avec ce qui reste
		int unite = n % 10;
		int ce_qui_reste = n / 10; // exemple: 948 / 10 = 94
		// afficher les unités en dernier
		chiffres(ce_qui_reste);
		printf("%d\n", unite);
	}
}

// Q4
/* Affiche k 'O' sur une ligne. (k >= 0) */
void affiche_O(int k){
	assert(k >= 0);
	if (k == 0){
		printf("\n");
	} else {
		printf("O");
		affiche_O(k-1);
	}
}

// Q5
/* Affiche les chiffres de n sur une ligne chacun,
   chaque chiffre k étant représenté par k 'O',
   de la plus grande puissance de 10 à la plus petite */
void chiffres_O(int n){
	// cas particulier: si n < 0, on commence par afficher
	// un - et on traite |n| ensuite
	if (n < 0){
		printf("-\n");
		chiffres_O(-n);
	} else if (n == 0) { 
		// ne rien faire
	} else {
		// enlever le chiffre des unités,
		// et recommencer avec ce qui reste
		int unite = n % 10;
		int ce_qui_reste = n / 10; // exemple: 948 / 10 = 94
		// afficher les unités en dernier
		chiffres_O(ce_qui_reste);
		affiche_O(unite);
	}
}




int main(){
	printf("### decompte(9) ###\n");
	decompte(9);
	printf("### decompte(2) ###\n");
	decompte(2);

	printf("### compte(10) ###\n");
	compte(10);
	printf("### compte(3) ###\n");
	compte(3);

	printf("### chiffres(9300514) ###\n");
	chiffres(9300514);
	printf("### chiffres(-77412) ###\n");
	chiffres(-77412);

	printf("### chiffres_O(9300514) ###\n");
	chiffres_O(9300514);
	printf("### chiffres_O(-77412) ###\n");
	chiffres_O(-77412);


	return 0;
}