#include <stdio.h>
#include <stdbool.h>
#include <assert.h>


// 1
/* Renvoie true si a divise b, false sinon.
   a doit être non-nul */
bool divise(int a, int b){
	assert(a != 0);
	return (b % a == 0);
}


// 2
/* Affiche x puis son inverse. x doit être non-nul */
void affiche_inverse(float x){
	assert(x != 0);
	printf("x vaut %f, son inverse vaut %f\n", x, 1/x);
}


// 3
/* Calcule A = 3x + 5y -6.25z + t.
   Affiche A, et renvoie le carré de A */
float lineaire(float x, float y, float z, float t){
	float A = 3*x + 5*y -6.25*z + t;
	printf("%f\n", A);
	return A*A;
}

int main(){
	// 1
	assert(divise(9, 45)); // assert sert aussi à valider des tests !
	assert(divise(12, 144));
	assert(divise(7, 0));
	assert(!divise(5, 14));
	assert(!divise(15, 5));

	// 2
	affiche_inverse(0.4);
	affiche_inverse(3);
	affiche_inverse(1);

	// 3
	assert(lineaire(0, 0, 0, 0) == 0);
	assert(lineaire(1, 2, 2, 1.5) == 4);
	assert(lineaire(2, 0, 1, 0) == 0.0625);

	printf("Fin des tests\n");
	return 0;
}