#include <stdio.h>
#include <stdbool.h>
#include <assert.h>


/* Renvoie la longueur du string s */
int str_len(char* s){
	int len = 0;
	while (s[len] != '\0'){
		len = len + 1;
	}
	// en sortie: len est l'indice du premier '\0' de s
	// donc s contient s[0], s[1], ... s[len-1], '\0'
	// len est bien la taille cherchée
	return len;
}

/* Renvoie le nombre d'occurrences de c dans s */
int occurrences(char* s, char c){
	int i = 0;
	int cpt = 0; // compteur
	while (s[i] != '\0'){
		if (s[i] == c){
			cpt = cpt + 1;
		}
	}
	return cpt;
}

/* Recopie le string src dans dst */
void str_cpy(char* dst, char* src){
	int i = 0;
	while (src[i] != '\0'){
		dst[i] = src[i];
		i++;
	}
	// ne pas oublier le caractère nul
	dst[i] = '\0';
}

/* Concatène le string src à la fin de dst */
void str_cat(char* dst, char* src){
	// trouver la fin de dst
	int fin_dst = str_len(dst);
	// rajouter les caractères de src à la suite de dst
	int i = 0;
	while (src[i] != '\0'){
		dst[fin_dst + i] = src[i];
		i++;
	}
	// ne pas oublier le caractère nul
	dst[fin_dst + i] = '\0';
}

/* Renvoie un entier comparant s1 et s2 dans l'ordre alphabétique:
   0 si égalité
   un entier < 0 si s1 < s2
   un entier > 0 si s1 > s2 */
int str_cmp(char* s1, char* s2){
	int i = 0;
	// lire jusqu'à sortir d'une des deux chaînes ou jusqu'à
	// trouver une position où les mots diffèrent
	while (s1[i] != '\0' && s2[i] != '\0' && s1[i] == s2[i]){
		i++;
	}
	// en sortie: 
	// (A) toutes les lettres de s1 et s2 entre 0 et i-1
	//     sont identiques
	// (B) soit s1[i] = 0 = s2[i], soit s1[i] != s2[i]
	// Finalement, s1[i] - s2[i] nous donne exactement
	// ce que l'on cherche: 0 si les chaînes sont égales,
	// un nombre positif si s1 est plus grand, un nombre
	// négatif sinon !
	return s1[i] - s2[i];
}






int main(){
	char bateau[20] = "bateau";
	char sur_leau[10] = "sur l'eau";
	char bateau_sur_leau[20] = "bateausur l'eau";
	char vide[20] = "";

	// TEST str_len
	assert(str_len(bateau) == 6);
	assert(str_len(vide)== 0);

	// TEST str_cmp
	assert(str_cmp("arbre", "bateau") < 0); 
	assert(str_cmp("chat", "bateau") > 0);
	assert(str_cmp("bateau", "bateau") == 0);
	// cas où une chaîne est préfixe de l'autre
	assert(str_cmp("bat", "bateau") < 0); 

	// deux chaînes identiques mais pas stockées au même endroit
	assert(bateau != "bateau"); // adresses différentes
	assert(str_cmp(bateau, "bateau") == 0); // même contenu

	// TEST str_cpy
	str_cpy(vide, bateau);
	assert(str_cmp(vide, "bateau") == 0);

	// TEST str_cat
	str_cat(bateau, sur_leau);
	assert(str_cmp(bateau_sur_leau, bateau) == 0);

	return 0;
}