#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>
#include <assert.h>
#include <math.h>

// ajoute 1 à l'entier pointé par p
void incrementer(int* p){
	assert(p != NULL);
    *p = *p + 1;  //
}



/* Échange le contenu des cases mémoires pointées par pa et pb */
void echange(float* pa, float* pb){
	float temporaire = *pa;
	*pa = *pb;
	*pb = temporaire;
}

/* Résout l'équation quadratique aX^2 + bX + c = 0
   et renvoie le nombre de solutions réelles (0, 1 ou 2).
   Stocke également la ou les racines réelles dans les zones 
   pointées par x1 et x2. */
int quad_solve(float a, float b, float c, float* x1, float* x2){
	float delta = b*b - 4*a*c;
	if (delta < 0){
		return 0;
	} else if (delta == 0){
		*x1 = -b / (2*a);
		return 1;
	} else { // delta négatif
		*x1 = (-b + sqrt(delta))/(2*a);
		*x2 = (-b - sqrt(delta))/(2*a);
		return 2;
	}
}

int main(){
	// test incrémenter
	int x = 3;
	printf("Avant: %d\n", x);
	incrementer(&x);
	printf("Après: %d\n", x);

	// test échange
	float a = 3.3, b = 9.47;
	printf("Avant échange: a = %f, b = %f\n", a, b);
	echange(&a, &b);
	printf("Après échange: a = %f, b = %f\n", a, b);
	

	// test quad_solve
	float x1, x2;

	// X^2 + 2X + 1: une solution
	int n1 = quad_solve(1, 2, 1, &x1, &x2); 
	assert(n1 == 1);
	printf("Solution de X^2 + 2X + 1 = 0: %f\n", x1);

	// X^2 + 2X - 3 = (X - 1)(X+3)
	int n2 = quad_solve(1, 2, -3, &x1, &x2); 
	assert(n2 == 2);
	printf("Solutions de X^2 + 2X - 3 = 0: %f et %f\n", x1, x2);

	// X^2 5 = 0: pas de solution réelle
	int n3 = quad_solve(1, 0, 5, &x1, &x2); 
	assert(n3 == 0);

	return 0;
}