#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>

/* calcule la somme des n premiers entiers de t. */
int somme(int* tab, int n){
	int res = 0;
	for (int i = 0; i < n; i++){
	    res += tab[i] ; // pareil que res = res + tab[i]
	}
	return res;
}

/* Affiche les n premiers éléments de tab sur une ligne */
void afficher(int* tab, int n){
	for (int i = 0; i < n; ++i){
		printf("%d ", tab[i]);
	}
	printf("\n");
}

/* Remplit les n premières cases de t avec n valeurs aléatoires
   entre -10 et 10 */
void tab_random(int* t, int n){
	for (int i = 0; i < n; ++i){
		t[i] = rand()%21 - 10;
	}
}

/* Remplit le tableau U de telle sorte que U[i] est la somme
   des i premières cases de T, pour i de 0 à n inclus */
void sommes_partielles(int* T, int* U, int n){
	U[0] = 0;
	for (int i = 0; i < n; ++i){
		U[i+1] = U[i] + T[i];
	}
}

int main(){
	srand(time(NULL));
	int t1[5] = {9, -3, 5, 0, 2};
	// tableau contenant 0, 1, 2, ..., 199
	int tab_long[200];
	for (int i = 0; i < 200; ++i){
		tab_long[i]= i;
	}

	// TEST somme
	assert(somme(t1, 5) == 13);
	assert(somme(t1, 4) == 11);
	assert(somme(t1, 1) == 9);
	assert(somme(t1, 0) == 0);

	// somme des entiers de 0 à 199
	assert(somme(tab_long, 200) == 200 * 199 / 2); 

	// TEST afficher
	printf("t1: ");
	afficher(t1, 5);
	printf("20 premières cases de tab_long:\n");
	afficher(tab_long, 20);
	printf("\n");

	// Test tab_random
	int t2[15];
	tab_random(t2, 15);
	printf("t2 après premier remplissage aléatoire\n");
	afficher(t2, 15);
	printf("\n");
	// modifier les 9 premières cases
	tab_random(t2, 9);
	printf("t2 après modification des 9 premières cases\n");
	afficher(t2, 15);
	printf("\n");

	// Test sommes_partielles
	int u1[6];
	sommes_partielles(t1, u1, 5);
	assert(u1[4] == somme(t1, 4));
	printf("Tableau des sommes partielles de t1: ");	
	afficher(u1, 6);

	int ulong[201];
	sommes_partielles(tab_long, ulong, 200);
	// vérifier que chaque case contient la bonne somme 
	for (int i = 0; i <= 200; ++i){
		assert(ulong[i] == somme(tab_long, i));
	}
	return 0;
}