#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <assert.h>
#include <stdbool.h>
#define N 1000

/* Renvoie true si t est trié, false sinon.
   n est la taille de t */
bool est_trie(int* t, int n){
	assert(t != NULL);
	for (int i = 1; i < n; i++){
		if (t[i-1] > t[i]){
			return false;
		}
	}
	return true;
}

/* Affiche le tableau t de taille n */
void print_tab(int* t, int n){
	assert(t != NULL);
	printf("[");
	if (n > 0){
		printf("%d", t[0]);
	}
	for (int i = 1; i < n; i++){
		printf(", %d", t[i]);
	}
	printf("]\n");
}

/* Remplit les n premières cases de t
   avec des entiers aléatoires entre 0 et 50 */
void random_tab(int* t, int n){
	assert(t != NULL);
	for (int i = 0; i < n; i++){
		t[i] = rand()%51;
	}
}

/* Échange les cases i et j de t un tableau supposé de taille n, si
   l'échange est autorisé, i.e. si i et j sont adjacentes.
   Renvoie un booléen indiquant si l'échange était autorisé ou non. */
bool echange(int* t, int i, int j, int n){
	assert(0 <= i && i < n && 0 <= j && j < n);
	if ((i != j+1) && (j != i+1)){
		return false;
	}
	int tmp = t[i];
	t[i] = t[j];
	t[j] = tmp;
	return true;
}


int main(){
	srand(time(NULL));
	int n;
	int t[N];
	int coups = 0;
	int i, j; // pour la saisie de l'utilisateur

	printf("Bienvenue au jeu du tri. Choisissez la taille du tableau: ");
	scanf("%d", &n);
	assert(n <= N);

	// generation du tableau de jeu
	random_tab(t, n);
	printf("Voici votre tableau:\n");
	print_tab(t, n);

	while (!est_trie(t, n)){
		printf("Rentrez les indices à échanger: ");
		scanf("%d %d", &i, &j);
		if (echange(t, i, j, n)){
			coups++;
		} else {
			printf("Coup invalide: les cases doivent être adjacentes\n");
		}
		print_tab(t, n);
	}
	printf("Bravo !! vous avez gagné en %d coup(s)\n", coups);

	return 0;
}