#include <stdio.h>
#include <assert.h>
#include <stdbool.h>

#define MAX_SIZE 1024

int size; // taille réelle de la mémoire
int mem_tab[MAX_SIZE]; // tableau des cases mémoires
bool no_value[MAX_SIZE]; // no_value[i] = 1 si une case n'a jamais reçu de valeur


/* Teste si l'indice i est valide pour une lecture,
   i.e. si la case i existe et contient une vraie valeur.
   Si ce n'est pas le cas, lève une erreur d'assertion. */
void assert_read(int i){
	assert(0 <= i && i < size);
	assert(!no_value[i]);
}

/* Teste si l'indice i est valide pour une lecture,
   i.e. si la case i existe et contient une vraie valeur
   Si ce n'est pas le cas, lève une erreur d'assertion. */
void assert_write(int i){
	assert(0 <= i && i < size);	
}

int get(int i){
	assert_read(i);
	return mem_tab[i];
}

void set(int i, int x){
	assert_write(i);
	mem_tab[i] = x;
	no_value[i] = false;
}

int add(int i, int j, int k){
	assert_read(i);
	assert_read(j);
	assert_write(k);
	mem_tab[k] = mem_tab[i] + mem_tab[j];
	no_value[k] = false;
	return mem_tab[k];
}


int main(){

	printf("Choisir la taille de la mémoire: ");
	scanf("%d", &size);

	// au départ, toutes les cases sont vides
	for (int i = 0; i < size; ++i)
	{
		no_value[i] = true;
	}

	int i, j, k, x; // pour la saisie de l'utilisateur

	bool quit = false;
	while (!quit){
		int choix;
		printf("Que voulez vous faire\n");
		printf("1. Accéder à une valeur\n");
		printf("2. Stocker une valeur\n");
		printf("3. Faire une addition\n");
		printf("4. Quitter le programme\n");
		printf("Choix :");
		scanf("%d", &choix);

		if (choix == 1){ // accéder
			printf("Rentrez l'adresse mémoire: ");
			scanf("%d", &i);
			int x = get(i);
			printf("La case %d contient %d\n", i, x);

		} else if (choix == 2){ // stocker
			printf("Rentrez l'adresse mémoire puis la valeur à stocker: ");
			scanf("%d %d", &i, &x);
			set(i, x);
			printf("%d stocké dans la case %d\n", x, i);

		} else if (choix == 3){ // addition
			printf("Rentrez trois adresses mémoires (source, source, destination): ");
			scanf("%d %d %d", &i, &j, &k);
			x = add(i, j, k);
			printf("La case %d contient maintenant %d\n", k, x);

		} else if (choix == 4){
			quit = true;
		} else {
			printf("Commande invalide\n");
		}
	}
	printf("Au revoir\n");
	return 0;
}