#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>

/* Renvoie une matrice nulle n x m */
int** zeros(int n, int m){
	int** res = malloc(n * sizeof(int*));
	for (int i = 0; i < n; ++i){
		res[i] = malloc(m * sizeof(int));
		for (int j = 0; j < m; ++j){
			res[i][j] = 0;
		}
	}
	return res;
}

/* Libère la mémoire allouée pour g, matrice à n lignes */
void free_mat(int** g, int n){
	for (int i = 0; i < n; ++i){
		free(g[i]);
	}
	free(g);
}

/* Affiche le contenu de la matrice g de dimensions n x m */
void print_mat(int** g, int n, int m){
	for (int i = 0; i < n; ++i){
		for (int j = 0; j < m; ++j){
			printf("%6d", g[i][j]);
		}
		printf("\n");
	}
}

/* Renvoie la somme de g1 et g2, matrices n x m */
int** somme_mat(int** g1, int** g2, int n, int m){
	int** s = zeros(n, m);
	for (int i = 0; i < n; ++i){
		for (int j = 0; j < m; ++j){
			s[i][j] = g1[i][j] + g2[i][j];
		}
	}
	return s;
}

/* Renvoie le produit de g1, matrice n x m
   par g2, matrice m x p. Le résultat est
   une matrice n x p */
int** prod_mat(int** g1, int** g2, int n, int m, int p){
	int** res = zeros(n, m);
	for (int i = 0; i < n; ++i){
		for (int j = 0; j < p; ++j){
			for (int k = 0; k < m; ++k){
				res[i][j] += g1[i][k]*g2[k][j];
			}
		}
	}	
	return res;
}

float moyenne_case(int** g, int n, int m, int i, int j){
	float somme = 0;
	int nombre = 0; // nombre de cases  
	// regarder les 9 cases concernées: g[i+di][j+dj]
	// avec di, dj variant de -1 à 1
	for (int di = -1; di <= 1; ++di){
		for (int dj = -1; dj <= 1; ++dj){
			// seulement compter les cases valides
			if (0 <= i + di && i + di < n && 
				 0 <= j + dj && j + dj < m){
				somme += g[i+di][j+dj];
				nombre += 1;
			}
		}
	}
	return somme/nombre;
}

void min_moy(int** g, int n, int m){
	int i0 = 0;
	int j0 = 0;
	float moyenne0 = moyenne_case(g, n, m, 0, 0);
	for (int i = 0; i < n; ++i){
		for (int j = 0; j < m; ++j){
			float moyenne = moyenne_case(g, n, m, i, j);
			if (moyenne < moyenne0){
				moyenne0 = moyenne;
				i0 = i;
				j0 = j;
			}
		}
	}
	printf("Plus petite moyenne en (%d, %d)\n", i0, j0);
	printf("Valeur: %f\n", moyenne0);
}

/* Renvoie true si g1 = g2, false sinon */
bool egal_mat(int** g1, int** g2, int n, int m){
	for (int i = 0; i < n; ++i){
		for (int j = 0; j < m; ++j){
			if (g1[i][j] != g2[i][j]){
				return false;
			}
		}
	}
	return true;
}

int main(){
	/* Z3:
	0 0 0
   0 0 0
   0 0 0  
	*/
	int** Z3 = zeros(3, 3);
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 3; ++j){
			assert(Z3[i][j] == 0);
		}
	}

	/* I3:
	1 0 0
   0 1 0
   0 0 1  
	*/
	int** I3 = zeros(3, 3);
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 3; ++j){
			I3[i][j] = (i == j);
		}
	}


	/* A:
	3 2 1
	6 5 4
	*/
	int** A = zeros(2, 3);
	for (int i = 0; i < 2; ++i){
		for (int j = 0; j < 3; ++j){
			A[i][j] = 3*(i+1) - j;
		}
	}

	/* B:
	0 2 
   1 3
   2 4 
	*/
	int** B = zeros(3, 2);
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 2; ++j){
			B[i][j] = i + 2*j;
		}
	}

	/* C:
	1 1 1
   0 1 1
   0 0 1  
	*/
	int** C = zeros(3, 3);
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 3; ++j){
			C[i][j] = (i <= j);
		}
	}

	/* D:
	1 2 3
   4 5 6
   7 8 9  
	*/
	int** D = zeros(3, 3);
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 3; ++j){
			D[i][j] = 3*i + j + 1;
		}
	}

	// TESTS
	printf("A:\n");
	print_mat(A, 2, 3);

	printf("B:\n");
	print_mat(B, 3, 2);

	printf("C:\n");
	print_mat(C, 3, 3);

	// somme matrice nulle
	int** CplusZ = somme_mat(C, Z3, 3, 3);
	assert(egal_mat(C, CplusZ, 3, 3));
	// somme quelconque
	int** CplusD = somme_mat(C, D, 3, 3);
	int attendu[3][3] = {
		{2, 3, 4},
		{4, 6, 7},
		{7, 8, 10}
	};
	for (int i = 0; i < 3; ++i){
		for (int j = 0; j < 3; ++j){
			assert(CplusD[i][j] = attendu[i][j]);
		}
	}
	// vérifier la commutativité
	int** DplusC = somme_mat(D, C, 3, 3);
	assert(egal_mat(CplusD, DplusC, 3, 3));

	free_mat(CplusZ, 3);
	free_mat(CplusD, 3);
	free_mat(DplusC, 3);

	// produit matrice nulle
	int** DfoisZ = prod_mat(D, Z3, 3, 3, 3);
	assert(egal_mat(DfoisZ, Z3, 3, 3));

	// produit matrice identité
	int** DfoisI = prod_mat(D, I3, 3, 3, 3);
	assert(egal_mat(DfoisI, D, 3, 3));



	// produit matrice quelconque
	int** AfoisB = prod_mat(A, B, 2, 3, 2);
	int attendu_prod[2][2] = {
		{4, 16},
		{13, 43}
	};
	for (int i = 0; i < 2; ++i){
		for (int j = 0; j < 2; ++j){
			assert(AfoisB[i][j] == attendu_prod[i][j]);
		}
	}
	free_mat(DfoisZ, 3);
	free_mat(DfoisI, 3);
	free_mat(AfoisB, 2);

	printf("Moyenne A:\n");
	min_moy(A, 2, 3);
	printf("Moyenne B:\n");
	min_moy(B, 3, 2);
	printf("Moyenne Z3:\n");
	min_moy(Z3, 3, 3);


	free_mat(A, 2);
	free_mat(B, 3);
	free_mat(C, 3);
	free_mat(D, 3);
	free_mat(Z3, 3);
	free_mat(I3, 3);
	return 0;
}
