#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>



int ma_getline(char** buffer, unsigned long int* n, FILE* f){
	if (*n == 0 && *buffer == NULL){
		*buffer = malloc(30*sizeof(char));
		*n = 30;
	}
	int i = 0; // nb d'octets lus
	bool fini = false; 
	char c = '\0';
	// Invariants:
	// - *buffer a *n octets alloués
	// - i octets ont été lus et stockés dans *buffer
	// - c est le caractère lu à l'étape précédente 
	while(!fini && c != '\n'){
		if (fscanf(f, "%c", &c) == EOF){
			fini = true;
		} else {			
			// augmenter la taille si nécessaire
			if (i+1 >= *n){
				*buffer = realloc(*buffer, 2 * (*n));
				*n = 2 * (*n);
			}
			(*buffer)[i] = c;
			i++;
		}
	}
	(*buffer)[i] = '\0';
	if (fini && i == 0){ // EOF atteint immédiatement
		return EOF;
	} else {
		return i;
	}
}




int main(int argc, char** argv){
	assert(argc >= 2);
	char* nom_fichier = argv[1];
	FILE* f = fopen(nom_fichier, "r");

	char* buffer = NULL;
	unsigned long int n = 0;

	bool fini = false;
	int i = 1; // numéro de la ligne
	while(!fini){
		int len = ma_getline(&buffer, &n, f);
		if (len == EOF){
			fini = true;
		} else {
			// enlever l'éventuel \n de fin
			if (buffer[len-1] == '\n'){
				buffer[len-1] = '\0';
			}
			printf("%d. %s\n", i, buffer);
			i++;
		}
	}

	free(buffer);
	fclose(f);
	return 0;
}
