#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>
#include <string.h>

/* Renvoie le nombre de lignes de `nom_fichier` */
int compter_lignes(char* nom_fichier){
	char* buffer = NULL;
	unsigned long int n = 0;
	FILE* f = fopen(nom_fichier, "r");	
	int i = 0;
	bool fini = false;
	while(!fini){
		int len = getline(&buffer, &n, f);
		if (len == EOF){
			fini = true;
		} else {
			i++;
		}
	}
	fclose(f);
	free(buffer);
	return i;
}

/* Renvoie un tableau contenant toutes les lignes de `nom_fichier`.
   Modifie n pour y mettre le nombre de lignes lues */
char** toutes_lignes(char* nom_fichier, int* n){
	*n = compter_lignes(nom_fichier);
	FILE* f = fopen(nom_fichier, "r");	
	char** res = malloc(*n * sizeof(char*));
	int i = 0;
	bool fini = false; // EOF atteint ?
	while(!fini){
		char* buffer = NULL;
		unsigned long int n = 0;
		int len = getline(&buffer, &n, f);
		if (len == EOF){
			fini = true;
			free(buffer);
		} else {
			// enlever l'éventuel \n de fin
			if (buffer[len-1] == '\n'){
				buffer[len-1] = '\0';
			}
			res[i] = buffer;
			i++;
		}

	}
	fclose(f);
	return res;
}

/* trie t, tableau de taille n contenant des chaînes
   de caractères. */
void trier(char** t, int n){
	for (int i = 0; i < n; ++i){
		// trouver le max de t[0], ..., t[n-1-i]
		int i_max = 0;
		for (int j = 0; j < n-i; ++j){
			if (strcmp(t[j], t[i_max])>0){
				i_max = j;
			}
		}
		// échanger t[i_max] et t[n-1-i]
		char* tmp = t[i_max];
		t[i_max] = t[n-1-i];
		t[n-1-i] = tmp;
	}
}


void tests(){
	assert(compter_lignes("test1.txt") == 3);
	assert(compter_lignes("test2.txt") == 6);
	assert(compter_lignes("test3.txt") == 0);
}

int main(int argc, char** argv){
	tests();
	assert(argc >= 2);
	char* nom_fichier = argv[1];
	int n = 0;
	char** lignes = toutes_lignes(nom_fichier, &n);
	trier(lignes, n);
	for (int i = 0; i < n; ++i){
		printf("%d. %s\n", i, lignes[i]);
		free(lignes[i]);
	}
	free(lignes);
	return 0;
}
