#include <stdio.h>
#include <assert.h>


/* Renvoie le nombre d'entiers strictement positifs lus dans le fichier 
   `nom_fichier` avant d'y lire un 0. Renvoie -1 si le fichier ne contient
   aucun 0.
   Précondition: `nom_fichier` ne doit contenir que des entiers. */
int premier_zero(char* nom_fichier){
	FILE* f = fopen(nom_fichier, "r"); // ouverture en mode lecture
	assert(f != NULL);
	int x = 0; // entier lu dans le fichier
	int tot_positif = 0; // nombre d'entiers > 0 lus
	while (fscanf(f, "%d", &x) != EOF){
		if (x == 0){
			fclose(f);
			return tot_positif;
		} else if (x > 0){
			tot_positif++;
		}
	} 
	// si l'on sort de la boucle, c'est qu'aucun 0 n'a été croisé
	fclose(f);
	return -1;
}




int main(){
	// TESTS
	assert(premier_zero("test1.txt") ==  5);
	assert(premier_zero("test2.txt") ==  3);
	assert(premier_zero("test3.txt") == -1);

	// MODE INTERACTIF

	char nom_fichier[51];
	// récupérer le nom du fichier
	printf("Veuillez entrer un nom de fichier:\n");
	scanf("%s", nom_fichier);

	int p = premier_zero(nom_fichier);
	if (p == -1){
		printf("Le fichier ne contient pas de 0\n");
	} else {
		printf("Le fichier contient %d entiers > 0 avant le premier 0\n", p);
	}
	return 0;
}