#include <stdio.h>
#include <string.h>
#include <assert.h>


/* Renverse la chaîne s */
void renverser(char* s){
	int l = strlen(s);
	for (int i = 0; i < l/2; ++i){
		char temp = s[l-i-1];
		s[l-i-1] = s[i];
		s[i] = temp;
	}
}


/* Renverse chaque mot de in_fn, et écrit dans out_fn */
void renverser_fichier(char* in_fn, char* out_fn){
	FILE* in_f  = fopen(in_fn,  "r");
	FILE* out_f = fopen(out_fn, "w");
	assert(in_f  != NULL);
	assert(out_f != NULL);

	char buf[51]; // mot lu
	while (fscanf(in_f, "%s", buf) != EOF){
		renverser(buf);
		fprintf(out_f, "%s ", buf);
	}
	fclose(out_f);
	fclose(in_f);
}

int main(){
	char s1[40] = "bonjour";
	char s2[40] = "UnTexteDansLeBonSens";
	renverser(s1);
	assert(strcmp(s1,"ruojnob") == 0);

	renverser(s2);
	assert(strcmp(s2,"sneSnoBeLsnaDetxeTnU") == 0);

	renverser_fichier("test_renverser.txt", "out_renverser.txt");
}