#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>

/* Renvoie true si les n premiers éléments
   de t1 et t2 sont égaux */
bool egaux(int* t1, int* t2, int n){
	for (int i = 0; i < n; ++i){
		if (t1[i] != t2[i]){
			return false;
		}
	}
	return true;
}

/* Renvoie un tableau de taille n, nul */
int* zeros(int n){
	int* t = malloc(n * sizeof(int));
	for (int i = 0; i < n; ++i){
		t[i] = 0;
	}
	return t;
}

/* Renvoie un tableau de n false puis m true */
bool* zeros_uns(int n, int m){
	bool* res = malloc((n + m) * sizeof(int));
	for (int i = 0; i < n; ++i){
		res[i] = false;
	}
	for (int i = n; i < n+m; ++i){
		res[i] = true;
	}
	return res;
}

/* Renvoie true si les n premiers éléments
   de t1 et t2 sont égaux */
bool egaux_bool(bool* t1, bool* t2, int n){
	for (int i = 0; i < n; ++i){
		if (t1[i] != t2[i]){
			return false;
		}
	}
	return true;
}

int main(){
	int* q2 = malloc(5*sizeof(int));
	for (int i = 0; i < 5; ++i){
		q2[i] = i;
	}
	free(q2);

	int* q3 = zeros(7);
	int test_q3[7] = {0, 0, 0, 0, 0, 0, 0};
	assert(egaux(q3, test_q3, 7));

	bool* q4 = zeros_uns(3, 5);
	bool test_q4[8] = {
		false, false, false, 
		true, true, true, true, true
	};
	assert(egaux_bool(q4, test_q4, 8));


	free(q3);
	free(q4);
	return 0;
}
