#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>

/* Renvoie un tableau d'au plus *n entiers lus
   dans le fichier filename. Stocke dans *n le
   nombre d'entiers effectivement lus. */
int* lire_entiers(char* filename, int* n){
	FILE* f = fopen(filename, "r");
	assert(f != NULL);
	int i = 0; // nb d'entiers lus
	int* t = malloc(*n * sizeof(int)); // entiers lus

	bool fini_de_lire = false;
	while(!fini_de_lire && i < *n){
		int nb_lus = fscanf(f, "%d", &t[i]);
		if (nb_lus == EOF){
			fini_de_lire = true; // termine la boucle
		} else {
			i++;
		}
	}
	// en sortie: soit on a atteint EOF, soit on a lu n entiers. 
	// Dans tous les cas, i contient le nombre d'entiers lus
	*n = i;
	fclose(f);
	return t;
}

int* lire_entiers_v2(char* filename, int* n){
	FILE* f = fopen(filename, "r");
	int i = 0;
	int* t = malloc(*n * sizeof(int));

	bool fini_de_lire = false;
	while(!fini_de_lire && i < *n){
		int nb_lus = fscanf(f, "%d", &t[i]);
		if (nb_lus == EOF){
			fini_de_lire = true;
		} else {
			i++;
		}
	}
	*n = i;
	// réallouer un autre tableau faisant pile la bonne taille
	int* res = malloc(i*sizeof(int));
	for (int j = 0; j < i; ++j){
		res[j] = t[j];
	}
	free(t);
	fclose(f);
	return res;
}


int main(){
	int n = 0;
	int* t = NULL;
	// test 1: demander plus d'entiers que le fichier en contient
	int attendu1[6] = {5, 12, 48, 74, 9, 6};
	n = 100;
	t = lire_entiers("test1.txt", &n);
	// vérifier la taille et les valeurs
	assert(n == 6);
	for (int i = 0; i < n; ++i){
		assert(attendu1[i] == t[i]);
	}
	free(t);

	// test 2: demander moins d'entiers que le fichier en contient
	int attendu2[5] = {1, 2, 3, 4, 5};
	n = 5;
	t = lire_entiers("test2.txt", &n);
	// vérifier la taille et les valeurs
	assert(n == 5);
	for (int i = 0; i < n; ++i){
		assert(attendu2[i] == t[i]);
	}
	free(t);

	// test 3: fichier vide
	n = 12;
	t = lire_entiers("test3.txt", &n);
	// vérifier la taille et les valeurs
	assert(n == 0);
	free(t);
	return 0;
}
