#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct animal{
	char espece[40];
	char nom[40];
	int age;
	float poids;
} animal_t;

typedef struct zoo{
	int n_animaux;
	animal_t** animaux;
} zoo_t;


/*Affiche les informations de l'animal pointé par a*/
void infos_animal(animal_t* a){
	printf("%s (%s), %d ans, %fkg\n", a->nom, a->espece, a->age, a->poids);
}


void infos_zoo(zoo_t* z){
	printf("%d animaux:\n", z->n_animaux);
	for (int i = 0; i < z->n_animaux; ++i)
	{
		infos_animal(z->animaux[i]);
	}
}


int compter_espece(zoo_t* z, char* espece){
	int compteur = 0;
	for (int i = 0; i < z->n_animaux; ++i)
	{
		if (strcmp(z->animaux[i]->espece, espece) == 0){
			compteur++;
		}
	}
}


int main(){
	printf("animal_t: %ld bytes\n", sizeof(animal_t));
	animal_t* a1 = malloc(sizeof(animal_t));
	animal_t* a2 = malloc(sizeof(animal_t));

	strcpy(a1->nom,"Grorf");
	strcpy(a1->espece,"Lion");
	a1->age = 17;
	a1->poids = 180;

	strcpy(a2->nom,"FLeurine");
	strcpy(a2->espece,"Giraffe");
	a2->age = 21;
	a2->poids = 963;

	zoo_t* z = malloc(sizeof(zoo_t));
	z->n_animaux = 2;
	z->animaux = malloc(2*sizeof(animal_t*));
	z->animaux[0] = a1;
	z->animaux[1] = a2;

	infos_zoo(z);

	free(a1);
	free(a2);
	free(z->animaux);
	free(z);

	return 0;
}
