#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>
#include <string.h>

struct cours {
	char intitule[50];
	char prof[50];
	int salle; // identifiant unique de la salle
	int jour;  // 0 (lundi) - 6 (dimanche)
}; 
typedef struct cours cours_t;

char* jours[7] = {"Lundi", "Mardi", "Mercredi", 
"Jeudi", "Vendredi", "Samedi", "Dimanche"};

/* Affiche les informations de c */
void afficher_infos(cours_t* c){
	printf("Cours: %s\n", c->intitule);
	printf("Enseignant: %s\n", c->prof);
	printf("Jour: %s\n", jours[c->jour]);
	printf("Salle: %d\n\n", c->salle);
}

/* Crée un cours alloué dans le tas, d'intitulé `intitule`, 
   enseigné par `prof`, dans la salle `salle`, le jour `jour` */
cours_t* creer_cours(char* intitule, char* prof, int salle, int jour){
	cours_t* c = malloc(sizeof(cours_t));
	c->salle = salle;
	c->jour  = jour;
	strcpy(c->intitule, intitule);
	strcpy(c->prof, prof);
	return c;
}


int main(){
	printf("Taille du type: %ld octets\n", sizeof(cours_t));

	cours_t maths = {
		.intitule = "Mathématiques",
		.prof     = "O.G.",
		.salle    = 0xDE02,
		.jour     = 1
	};

	cours_t phy;
	strcpy(phy.intitule, "Physique");
	strcpy(phy.prof, "A.B.");
	phy.salle = 0xA212;
	phy.jour = 2;

	cours_t info = {
		.intitule = "Informatique",
		.salle = 0xC205
	};
	info.jour = 4;
	strcpy(info.prof, "G.R.");

	afficher_infos(&maths);
	afficher_infos(&phy);
	afficher_infos(&info);

	cours_t* angl = creer_cours("Anglais", "P.P.", 0xDE02, 0);
	afficher_infos(angl);
	free(angl);

	return 0;
}