#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct etudiant {
	char* prenom;
	unsigned int age;
};
typedef struct etudiant etu_t;

typedef struct equipe{
	unsigned int nb_membres;
	etu_t** membres; // tableaux de pointeurs vers les membres de l'equipe
	unsigned int indice_cpt; // indice du capitaine dans le tableau des membres
} equipe_t;

/* Affiche les informations de l'étudiant e */
void print_etu(etu_t* e){
	printf("%s (%d ans)\n", e-> prenom, e->age);
}

/* Affiche les membres de l'équipe e */
void print_equipe(equipe_t* e){
	for (int i = 0; i < e->nb_membres; ++i){
		if (i == e->indice_cpt){
			printf("Capitaine: ");
		} else {
			printf("Membre   : ");
		}
		print_etu(e->membres[i]);
	}
}

/* Libère la mémoire allouée pour e */
void free_etu(etu_t* e){
	free(e->prenom);
	free(e);
}

/* Libère la mémoire allouée pour e */
void free_equipe(equipe_t* e){
	for (int i = 0; i < e->nb_membres; ++i){
		free_etu(e->membres[i]);
	}
	free(e->membres);
	free(e);
}

/* Fusionne les équipes dst et src. Le pointeur src devient
   inutilisable après appel, la nouvelle équipe est stockée
   dans dst. */
void agrandir_equipe(equipe_t* dst, equipe_t* src){
	int n1 = dst->nb_membres;
	int n2 = src->nb_membres;

	int n = n1 + n2;
	// ajouts des membres des deux équipes: 
	// les membres de l'équipe dst seront entre 0 et n1 - 1
	// les membres de l'équipe src seront entre n1 et n1 + n2 - 1
	etu_t** nouveaux_membres = malloc(n * sizeof(etu_t*));
	for (int i = 0; i < n1; ++i){
		nouveaux_membres[i] = dst->membres[i];
	}
	for (int i = 0; i < n2; ++i){
		nouveaux_membres[n1+i] = src->membres[i];
	}
	// choix du/de la capitaine
	int nouv_cpt;
	if (n1 > n2){
		nouv_cpt = dst->indice_cpt; 
	} else {
		nouv_cpt = n1 + src->indice_cpt; 
	}

	// libérer l'équipe src. Il ne faut pas utiliser la fonction free_equipe
	// sinon on libère la moitié des étudiants de la nouvelle équipe 
	free(src->membres);
	free(src);

	// plus besoin du tableau des membres pour dst, on le remplace par
	// le nouveau tableau
	free(dst->membres);
	dst->membres = nouveaux_membres;
	dst->nb_membres = n;
	dst->indice_cpt = nouv_cpt;

}

/* Crée une équipe de 3 membres */
equipe_t* mon_equipe1(){
	equipe_t* e1 = malloc(sizeof(equipe_t));
	e1->nb_membres = 3;
	e1->membres = malloc(3*sizeof(etu_t*));
	for (int i = 0; i < 3; ++i){
		e1->membres[i] = malloc(sizeof(etu_t));
	}

	e1->membres[0]->age = 23;
	e1->membres[0]->prenom = malloc(10*sizeof(char));
	strcpy(e1->membres[0]->prenom, "Camille");

	e1->membres[1]->age = 20;
	e1->membres[1]->prenom = malloc(10*sizeof(char));
	strcpy(e1->membres[1]->prenom, "Leila");
	e1->indice_cpt = 1;

	e1->membres[2]->age = 22;
	e1->membres[2]->prenom = malloc(10*sizeof(char));
	strcpy(e1->membres[2]->prenom, "Thibault");

	return e1;
}

/* Crée une équipe de 2 membres */
equipe_t* mon_equipe2(){
	equipe_t* e1 = malloc(sizeof(equipe_t));
	e1->nb_membres = 2;
	e1->membres = malloc(2*sizeof(etu_t*));
	for (int i = 0; i < 2; ++i){
		e1->membres[i] = malloc(sizeof(etu_t));
	}

	e1->membres[0]->age = 23;
	e1->membres[0]->prenom = malloc(20*sizeof(char));
	strcpy(e1->membres[0]->prenom, "Sang-hyeok");

	e1->membres[1]->age = 20;
	e1->membres[1]->prenom = malloc(10*sizeof(char));
	strcpy(e1->membres[1]->prenom, "Serena");
	e1->indice_cpt = 1;

	return e1;
}

int main(){
	equipe_t* e1 = mon_equipe1();
	printf("Équipe 1:\n");
	print_equipe(e1);
	free_equipe(e1);


	e1 = mon_equipe1();
	equipe_t* e2 = mon_equipe2();
	agrandir_equipe(e2, e1);
	printf("Fusion des deux équipes:\n");
	print_equipe(e2);
	free_equipe(e2);
	return 0;
}