import matplotlib.pyplot as plt
import math

def lire_valeurs(fn):
    """
    Lit une liste de flottants dans fn et la renvoie
    """
    # ouverture en mode lecture
    f = open(fn, "r")
    # chaîne de caractère avec tout le contenu du fichier
    contenu = f.read()
    # sépare en sous-chaînes selon les espaces et les '\n'
    nombres = contenu.split()
    # transforme chaque sous-chaîne en flottant
    nombres = list(map(float, nombres))
    # fermeture du fichier
    f.close()
    return nombres


def comparer_tris():
    """
    Trace les courbes des temps d'exécution des tris rapide et par insertion.
    """
    liste_n = list(range(100, 4001, 100)) # de 100 à 4000 par pas de 100
    valeurs_rapide = lire_valeurs("valeurs/rand_rapide.txt")
    valeurs_insertion = lire_valeurs("valeurs/rand_insertion.txt")

    plt.plot(liste_n, valeurs_rapide, 'r-', label="Tri rapide")
    plt.plot(liste_n, valeurs_insertion, 'b-', label="Tri insertion")

    # légendes des courbes / axes
    plt.xlabel("Taille du tableau")
    plt.ylabel("Temps (ms)")
    plt.legend()

    plt.savefig("comparaison_random.png")
    plt.show()

def verifier_allures():
    """
    Trace deux courbes I et R avec:
    I(n) = temps du tri par insertion sur un tableau de taille n, divisé par n^2
    R(n) = temps du tri rapide        sur un tableau de taille n, divisé par 10n log n
    """
    liste_n = list(range(100, 4001, 100)) # de 100 à 4000 par pas de 100
    valeurs_rapide = lire_valeurs("valeurs/rand_rapide.txt")
    valeurs_insertion = lire_valeurs("valeurs/rand_insertion.txt")

    for k in range(len(liste_n)):
        n = liste_n[k]
        valeurs_insertion[k] = valeurs_insertion[k] / (n*n)
        valeurs_rapide[k] = valeurs_rapide[k] / (10*n*math.log(n))


    plt.plot(liste_n, valeurs_rapide, 'r-', label="Tri rapide (divisé par $10 n \\log_{10}(n)$)")
    plt.plot(liste_n, valeurs_insertion, 'b-', label="Tri insertion (divisé par $n^2$)")

    # légendes des courbes / axes
    plt.xlabel("Taille du tableau")
    plt.ylabel("Temps (ms)")
    plt.legend()

    plt.savefig("allures_random.png")
    plt.show()

def comparer_mediane_rand():
    """
    Compare le tri rapide classique et la variante utilisant la médiane
    de trois éléments comme pivot, sur des tableaux aléatoires.
    """
    liste_n = list(range(100, 4001, 100)) # de 100 à 4000 par pas de 100
    valeurs_rapide  = lire_valeurs("valeurs/rand_rapide.txt")
    valeurs_mediane = lire_valeurs("valeurs/rand_mediane.txt")

    plt.plot(liste_n, valeurs_rapide, 'r-', label="Tri rapide")
    plt.plot(liste_n, valeurs_mediane, 'b-', label="Tri rapide (médiane de 3)")

    # légendes des courbes / axes
    plt.xlabel("Taille du tableau")
    plt.ylabel("Temps (ms)")
    plt.legend()

    plt.savefig("comparaison_mediane_random.png")
    plt.show()

def comparer_mediane_decr():
    """
    Compare le tri rapide classique et la variante utilisant la médiane
    de trois éléments comme pivot, sur des tableaux décroissants.
    """
    liste_n = list(range(100, 4001, 100)) # de 100 à 4000 par pas de 100
    valeurs_rapide  = lire_valeurs("valeurs/decr_rapide.txt")
    valeurs_mediane = lire_valeurs("valeurs/decr_mediane.txt")

    plt.plot(liste_n, valeurs_rapide, 'r-', label="Tri rapide")
    plt.plot(liste_n, valeurs_mediane, 'b-', label="Tri rapide (médiane de 3)")

    # légendes des courbes / axes
    plt.xlabel("Taille du tableau")
    plt.ylabel("Temps (ms)")
    plt.legend()

    plt.savefig("comparaison_mediane_decr.png")
    plt.show()


def courbes_hybrides():
    """
    Compare les performances du tri hybride avec différentes valeurs
    de seuil.
    """
    liste_n = list(range(10000, 100001, 10000))
    valeurs_mediane = lire_valeurs("valeurs/trie_mediane.txt")
    plt.plot(liste_n, valeurs_mediane, 'b--', label="Tri rapide (médiane de 3)")

    for K in range(5, 500, 50):
        # f"...{x}..." remplace {x} par la valeur de x dans la chaîne de caractère.
        valeurs = lire_valeurs(f"valeurs/trie_hybride_{K}.txt")
        plt.plot(liste_n, valeurs, label=f"Tri hybride (K={K})")


    # légendes des courbes / axes
    plt.xlabel("Taille du tableau")
    plt.ylabel("Temps (ms)")
    plt.legend()

    plt.savefig("comparaison_hybride.png")
    plt.show()


