/* Implémentation des piles par tableaux */
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>
#include <stdio.h>

#include "pile.h"

#define Nmax 1000
struct pile {
	int nb_elem;
	int* tab;
};

pile_t* pile_vide(){
	pile_t* p = malloc(sizeof(pile_t));
	p->nb_elem = 0;
	p->tab = malloc(Nmax*sizeof(int));
	return p;
}

bool est_vide(pile_t* p){
	return (p->nb_elem == 0);
}

void empiler(pile_t* p, int x){
	// Redimensionner
	assert(p->nb_elem < Nmax);
	p->tab[p->nb_elem] = x;
	p->nb_elem++;
}

int depiler(pile_t* p){
	assert(!est_vide(p));
	int res = p->tab[p->nb_elem-1];
	p->nb_elem--;
	return res;
}

void free_pile(pile_t* p){
	free(p->tab);
	free(p);
}


void affiche_pile(pile_t* p){
	for (int i = 0; i < p->nb_elem; ++i)
	{
		printf("%d ", p->tab[i]);
	}
	printf("\n");
}