/* Implémentation des files par tableaux cycliques */
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>
#include <stdio.h>

#include "file.h"



#define Nmax 10
struct file {
	int queue; //prochaine case à remplir
	int nb_elem;
	int tab[Nmax];
};

file_t* file_vide(){
	printf("Création d'une file implémentée par tableaux\n");
	file_t* f = malloc(sizeof(file_t));
	f->nb_elem = 0;
	f->queue = 0;
	return f;
}

bool est_file_vide(file_t* f){
	return (f->nb_elem == 0);
}

void enfiler(file_t* f, int x){
	assert(f->nb_elem < Nmax);

	f->tab[f->queue] = x;
	f->queue = (f->queue+1) % Nmax;
	f->nb_elem++;
}

int defiler(file_t* f){
	assert(!est_file_vide(f));
	int res = f->tab[(Nmax+f->queue - f->nb_elem)%Nmax];
	f->nb_elem--;
	return res;
}

void free_file(file_t* f){
	free(f);
}


void affiche_file(file_t* f){
	printf("Etat de la file:\n");
	for (int i = 0; i < f->nb_elem; i++){
		printf("%c ", f->tab[(f->queue + (Nmax - f->nb_elem + i))%Nmax]);
	}
	printf("\n");
}