#include "pile.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <assert.h>

/* Renvoie la forme stable de p */
char* forme_stable(char* p){
	pile_t* P = pile_vide();
	for (int i = 0; p[i] != '\0'; ++i){
		if (!est_vide(P)){
			char x = depiler(P);
			if (x -'a'+'A' != p[i] && x + 'a' - 'A' != p[i]){
				// pas de réaction
				empiler(P, x);
				empiler(P, p[i]);
			}
		} else {
			empiler(P, p[i]);
		}
	}
	// fin des réactions: on dépile P dans une chaîne
	int n = taille(P);
	char* s = malloc((n+1)*sizeof(char));
	int i = n-1;
	while(!est_vide(P)){
		s[i] = depiler(P);
		i--;
	}
	s[n] = '\0';
	free_pile(P);
	return s;
}


/* Renvoie l'intégralité du contenu du fichier nom_fichier. Renvoie
   NULL si l'ouverture échoue. */
char* lire(char* nom_fichier){
	FILE* f = fopen(nom_fichier, "r");
	if (f == NULL){
		return NULL;
	}

	char* p = malloc(101*sizeof(char));
	int n = 0; // nombre de caractères lus
	int n_max = 100; // nombre de caractères réservés
	char c;
	while (fscanf(f, "%c", &c) != EOF){
		// réallouer si nécessaire
		if (n == n_max){
			n_max *= 2;
			p = realloc(p, (2*n_max+1)*sizeof(char));
		}
		p[n] = c;
		n++;
	}
	p[n] = '\0';
	fclose(f);
	return p;
}

int test(){
	char* p = "abcd";
	char* s = forme_stable(p);
	assert(strcmp(s, "abcd") == 0);
	free(s);

	p = "abcdDCBA";
	s = forme_stable(p);
	assert(strcmp(s, "") == 0);
	free(s);

	p = "abcBbCA";
	s = forme_stable(p);
	assert(strcmp(s, "abA") == 0);
	free(s);
}

int main(int argc, char** argv){
	test();
	if (argc < 2){
		printf("Veuillez préciser le fichier contenant le polymère à stabiliser\n");
		exit(1);
	}

	char* polymere = lire(argv[1]);
	if (polymere == NULL){
		printf("Fichier invalide, ou erreur d'ouverture\n");
		exit(1);
	}
	printf("Polymère lu, de taille %ld\n",strlen(polymere));

	char* stable = forme_stable(polymere);
	printf("Forme stable de taille %ld\n", strlen(stable));

	free(polymere);
	free(stable);
	return 0;
}