import requests
import json

def nombre_visites(article, debut, fin):
    """
    Renvoie le nombre de visites mensuelles de l'article Wikipedia
    `article` entre les dates debut et fin.
    Entrées:
    - article: nom de l'article. Doit être un article anglais
    - debut et fin: dates limites incluses dans la requête.
      Doivent être au format "YYYYMM", par exemple "201605" pour Mai 2016.
    Sortie: liste de couples [(d1, n1), ..., (dk, nk)] avec chaque
    dj une date et chaque nj le nombre de visites à cette date.
    """

    url = f"https://wikimedia.org/api/rest_v1/metrics/pageviews/per-article/en.wikipedia/all-access/all-agents/{article}/monthly/{debut}0100/{fin}0100"

    headers = {f'User-Agent': 'MP2I_Bot/0.0 (guillaume.rousseau@ens-lyon.fr)'}
    response = requests.get(url, headers = headers)

    data = json.loads(response.text)

    return [(it['timestamp'], it['views']) for it in data["items"]]


