import requests
import json

import numpy as np
import matplotlib.pyplot as plt

def nombre_visites(article, debut, fin):
    """
    Renvoie le nombre de visites mensuelles de l'article Wikipedia
    `article` entre les dates debut et fin.
    Entrées:
    - article: nom de l'article. Doit être un article anglais
    - debut et fin: dates limites incluses dans la requête.
      Doivent être au format "YYYYMM", par exemple "201605" pour Mai 2016.
    Sortie: liste de couples [(d1, n1), ..., (dk, nk)] avec chaque
    dj une date et chaque nj le nombre de visites à cette date.
    """

    url = f"https://wikimedia.org/api/rest_v1/metrics/pageviews/per-article/en.wikipedia/all-access/all-agents/{article}/monthly/{debut}0100/{fin}0100"

    headers = {f'User-Agent': 'MP2I_Bot/0.0 (guillaume.rousseau@ens-lyon.fr)'}
    response = requests.get(url, headers = headers)

    data = json.loads(response.text)

    return [(it['timestamp'], it['views']) for it in data["items"]]


visites = nombre_visites("Computer Science", "202301", "202401")

def total_visites(article, debut, fin):
    """
    Renvoie le nombre total de visites d' `article` entre
    les dates `debut` et `fin`.
    """
    vis = nombre_visites(article, debut, fin)
    res = 0
    for (date, vues) in vis:
        res += vues
    return res

total = total_visites("Computer Science", "202301", "202401")


"""
Visites cumulées:
La première version proposée utilise une boucle for classique
allant de 0 à n-1, la deuxième version permet d'itérer directement
sur les éléments sans passer par l'indice, en utilisant la syntaxe
for a in l:
    ...
comme l contient des couples on peut même écrire:
for (x, y) in l:
    ...
"""
def visites_cumulees_version1(article, debut, fin):
    visites = nombre_visites(article, debut, fin)
    cumuls = [None for i in range(len(visites))]
    tot = 0
    for i in range(len(visites)):
        date, vues = visites[i]
        tot += vues
        cumuls[i] = (date, tot)
    return cumuls

def visites_cumulees(article, debut, fin):
    visites = nombre_visites(article, debut, fin)
    cumuls = []
    tot = 0
    for date, vues  in visites:
        tot += vues
        cumuls.append((date, tot))
    return cumuls

cumuls = visites_cumulees("Computer Science", "202301", "202401")


def plot_monthly_views(articles, debut, fin):
    """
    Trace les courbes des visites cumulées pour chaque article
    dans `articles`, entre `debut` et `fin`.
    """
    n = len(articles)
    for i in range(n):
        # récupérer les données et en extraire la liste
        # des abscisses et celle des ordonnées
        vis = visites_cumulees(articles[i], debut, fin)
        x = [date for (date, vues) in vis]
        y = [vues for (date, vues) in vis]
        plt.plot(x, y, label=articles[i])
    plt.legend(loc="lower right") # légendes des courbes
    plt.xticks(rotation=85) # affichage plus joli des abscisses
    plt.show()

articles = [
    "Pierre de Fermat",
    "Computer Science",
    "Chocolatine",
]
plot_monthly_views(articles, "202301","202501")




