
(* liste des caractères de s à partir de l'indice
   i inclus *)
let rec list_of_string_from_i (s: string) (i: int) : char list =
	if i = String.length s then []
	else s.[i] :: list_of_string_from_i s (i+1)

(* liste des caractères de s *)
let list_of_string (s: string) : char list =
	list_of_string_from_i s 0

(* Q2: String.split_on_char permet de séparer
   une chaîne de caractères en blocs, selon un
   caractère de séparation.
   Par exemple: 
   String.split_on_char 'a' "séparation" = ["sép";"r";"tion"] *)



let string_of_list (l: char list) : string =
	String.of_seq (List.to_seq l)

(* liste de strings obtenus en séparant s[i..] selon
   le séparateur sep, avec curr qui contient les
   caractères lus dans le segment actuel. *)
let rec split_from_i 
	(s: string) (sep: char) (i: int) (curr: char list) : string list =
	if i = String.length s then 
		(* curr est stockée à l'envers, il faut la renverser *)
		[string_of_list (List.rev curr)]
	else if s.[i] = sep then (* on a fini de lire un segment *)
		string_of_list (List.rev curr) :: split_from_i s sep (i+1) []
    else (* on rajoute la lettre au segment actuel *)
        split_from_i s sep (i+1) (s.[i] :: curr)

let split (s: string) (sep: char) : string list =
	split_from_i s sep 0 []

(* Quelques tests *)
let test_split () =
	assert (split "segmentation" 'e' = ["s";"gm";"ntation"]);
	assert (split "chaîne de caractères" ' ' = ["chaîne"; "de"; "caractères"]);
	assert (split "balle" 'l' = ["ba";"";"e"])