type couleur = Coeur | Carreau | Pique | Trefle

let couleur1 = Pique

(* true si c est une couleur rouge, faux sinon *)
let est_rouge (c: couleur) : bool = match c with
	| Coeur   -> true
	| Carreau -> true
	| Pique   -> false
	| Trefle  -> false

let _ =
	assert (est_rouge Carreau) (* vaut true *)

type tete = Valet | Dame | Roi

type carte = 
	| Nombre of int * couleur (* Cartes 2 à 10 et As *)
	| Tete of tete * couleur
	| Joker

let carte_1 = Tete (Valet, Coeur) 
let carte_2 = Nombre (9, Pique)

(* Renvoie la couleur de ca *)
let couleur_de_carte (ca: carte) : couleur = 
	match ca with
	| Nombre (_, cou) -> cou 
	| Tete (_, cou) -> cou
	| Joker -> failwith "pas de couleur"

(* chaine de caractère représentant c *)
let string_of_couleur (c: couleur) : string = 
	match c with
	| Coeur -> "coeur"
	| Pique -> "pique"
	| Trefle -> "trèfle"
	| Carreau -> "carreau"

let string_of_tete (t: tete) =
	match t with 
	| Valet -> "Valet"
	| Dame -> "Dame"
	| Roi -> "Roi"

(* chaine de caractère représentant ca *)
let string_of_carte (ca: carte) : string = 
	match ca with
	| Nombre (1, cou) -> "As de " ^ string_of_couleur cou
	| Nombre (n, cou) -> string_of_int n ^ " de " ^ string_of_couleur cou
	| Tete (t, cou) -> string_of_tete t ^ " de " ^ string_of_couleur cou
	| Joker -> "Joker"	


(* Renvoie -1, 0 ou 1 selon si ca1 est inférieure, égale
   ou supérieure à ca2 dans l'ordre suivant:
   coeur < carreau < pique < trefle et au sein d'une
   couleur 2 < 3 < ... < 10 < valet < dame < roi < as *)
let comparer_cartes (ca1: carte) (ca2: carte) : int = 
	if ca1 = ca2 then 0 else
	(* on va mettre le joker tout en haut de l'ordre *)
	if ca1 = Joker then 1 else if ca2 = Joker then -1 else
	(* Commencer par comparer les couleurs. L'ordre des couleurs
	   a été changé au tout début du fichier, pour correspondre
	   à l'ordre demandé dans le sujet *)
	let cou1, cou2 = couleur_de_carte ca1, couleur_de_carte ca2 in
	if cou1 < cou2 then -1
	else if cou1 > cou2 then 1
	else match ca1, ca2 with
		| Nombre (1, _), _ -> 1
		| _, Nombre (1, _) -> -1
		| _ -> (* dans tous les autres cas, l'ordre natif d'OCaml convient *)
			    if ca1 < ca2 then -1 else 1 

(* Insère ca dans main selon l'ordre dicté par comparer_cartes.
   Précondition: main est triée selon ce même ordre *)
let rec inserer2 (ca: carte) (main: carte list) = 
	match main with
	| [] -> [ca]
	| x :: q -> if comparer_cartes ca x <= 0 then ca::x::q 
	          else x :: inserer2 ca q

(* liste triée selon comparer_cartes contenant les éléments de l *)
let rec tri_insertion (l: carte list) : carte list = 
	match l with
	| [] -> []
	| x::q -> inserer2 x (tri_insertion q);;

(** Quelques opérateurs et fonctions pratiques sur les listes **)
(* @ fait une concaténation. ATTENTION c'est un opérateur
   très dangereux car il donne l'impression d'être aussi simple
   qu'une addition, mais en réalité il s'exécute comme la fonction 
   concatener de l'exercice 1, avec une complexité linéaire en la
   taille de la liste de gauche. Il faut s'en servir avec parcimonie.
   Ici c'est justifiable car les listes que l'on concatène sont de
	taille fixe (10). *)

(* Liste contenant toutes les cartes de la couleur cou *)
let gen_couleur (cou: couleur) : carte list = 
	(* listes des nombres de la couleur cou, à partir de k inclus *)
	let rec nombres cou k = match k with
		|  0 -> []
		|  _ -> Nombre (k, cou):: nombres cou (k-1)
	in nombres cou 10 @ ([Tete (Valet, cou); Tete (Dame, cou); Tete(Roi, cou)])

(* List.concat fait la même chose que multiconcat de l'exercice 1:
   elle prend une liste de listes et les concatènes toutes. *)
(* List.map est la fonction map des exercices 1 et 2 *)

(* renvoie un deck entier trié *)
let gen_deck () = 
	(* on génère la liste de chaque couleur et on concatène le tout *)
	let deck = List.concat (List.map gen_couleur [Coeur; Pique; Trefle; Carreau])
	in let deck = Joker :: deck in 
	tri_insertion deck







