type boisson = 
	| Eau
	| Jus of string
	| BreizhCola of bool (* true si light, false sinon *)
	| Cocktail of boisson * boisson * float (* deux boissons b1 b2, et la proportion de b1 *)

(* prix au litre de b*)
let rec prix (b: boisson) : float = match b with
	| Eau -> 0.
	| BreizhCola _ -> 1.
	| Jus "ramboutan" -> 5.3
	| Jus _ -> 3.
	| Cocktail (b1, b2, x) -> x *. prix b1 +. (1. -. x) *. prix b2

(* boisson de la forme Cocktail(0.5, b1, Cocktail(0.5, b2, ....))
   où l_boissons = [b1; b2; ... bn] *)
let rec shaker (l_boissons: boisson list) : boisson =
	match l_boissons with
	| [] -> failwith "shaker vide"
	| x :: [] -> x 
	| x :: q -> Cocktail (x, shaker q, 0.5)

(* chaîne représentant b une boisson de base *)
let string_of_boisson (b: boisson) : string = 
	match b with 
	| Cocktail _ -> failwith "Pas une boisson de base"
	| Eau -> "Eau"
	| Jus fruit -> begin match fruit.[0] with 
					| 'a' | 'o' | 'e' | 'i' | 'u' | 'h' -> "Jus d'" ^ fruit
					| _ -> "Jus de " ^ fruit
				   end   
	| BreizhCola true -> "Breizh Cola Light"
	| BreizhCola false -> "Breizh Cola"


(* Liste des ingrédients de b *)
let ingredients (b: boisson) : (boisson*float) list =
	(* Fonction auxiliaire:
	   Liste des ingrédients de bb, avec chaque proportion multipliée par p *)
	let rec ingredients_fraction 
		(bb: boisson) 
		(p: float) 
		: (boisson*float) list =
		match bb with 
			| Eau | Jus _ | BreizhCola _ -> [(bb, p)]
			| Cocktail (b1, b2, x) -> 
				ingredients_fraction b1 (p*.x) @ 
				ingredients_fraction b2 (p*.(1. -. x))
	in ingredients_fraction b 1.

(* Regroupe les éléments de l par première composante,  en sommant
   sur la deuxième composante. Précondition: l est triée, et
   en particulier, les éléments de même première composante sont
   tous consécutifs *)
let agreg_sum (l: ('a * float) list) : ('a * float) list =
	(* agreg_sum_curr ll curr curr_p renvoie agreg_sum ll, en ayant déjà
	   vu une quantité curr_p de l'élément curr. *)
	let rec agreg_sum_curr 
		(ll: ('a * float) list) (curr: 'a) (curr_p: float) : ('a * float) list  = 
		match ll with 
		| [] -> [(curr, curr_p)]
		| (x, p) :: q -> if x = curr then agreg_sum_curr q curr (curr_p +. p)
						 else (curr, curr_p) :: agreg_sum_curr q x p
	in match l with 
	| [] -> []
	| (x, p) :: q -> agreg_sum_curr q x p


(* Affiche la recette de b *)
let recette (b: boisson) : unit =
	let l = ingredients b in
	let l_regroupee = agreg_sum (List.sort compare l) in
	print_string "Recette pour 1L:\n";
	(* Affiche chaque couple (bb, p) de ll sous la forme:
	    p mL de bb\n
	   Chaque boisson bb de ll doit être une boisson de base. *)
	let rec aff_liste (ll: (boisson * float) list) : unit = 
		match ll with 
		| [] -> ()
		| (bb, p) :: q -> begin 
			print_int (int_of_float (p *. 1000.)); 
			print_string " mL ";
			print_string (string_of_boisson bb);
			print_newline ();
			aff_liste q
		end
	in aff_liste l_regroupee

let test () =
	let b =
	Cocktail(
		Cocktail(
			Jus "raisin",
			Cocktail(
				BreizhCola true,
				Eau,
				0.5
			),
			0.4
		),
		Cocktail(
			Jus "raisin",
			BreizhCola false,
			0.7
		), 
		0.1
	)
	in recette b

