import numpy as np
import matplotlib.pyplot as plt

a = plt.imread("poivrons.jpg") # charge l'image

plt.imshow(a) # dessine l'image dans la fenêtre de pyplot (sans l'afficher)
plt.show() # affiche la fenêtre pyplot


# a est une matrice numpy à trois dimensions.
# Les dimensions s'obtiennent avec a.shape:
n, m, k = a.shape
# a est une matrice de n lignes et m colonnes de pixels.
# Chaque pixel est composé de k valeurs. Dans la suite, on supposera que
# k vaut toujours 3 et que a[i, j] contient un triplet [r,g,b] représentant
# un pixel par codage RGB.

# On ne peut pas modifier a, mais on peut en créer une copie, et
# modifier la copie:
b = a.copy() # copie intégrale de a
b[0, 0, 2] = 0 # enlève le bleu du pixel en haut à gauche
b[36,45] = np.uint8([255,121,234]) # remplace le pixel ligne 36, colonne 45

b[:, 500] = np.uint8([255, 255, 255]) #remplace toute la colonne 500 par des pixels blanc
b[300, :] = np.uint8([255, 0, 0]) #remplace toute la ligne 300 par des pixels rouges
plt.imsave("poivrons2.jpg", b) # sauvegarde l'image de la matrice b