## 1 Manipulations pixel par pixel

import numpy as np
import matplotlib.pyplot as plt

def noR(a):
    """
    Copie de a sans les composantes rouge
    """
    b = a.copy()
    n, m, k = a.shape
    for i in range(n):
        for j in range(m):
            b[i, j, 0] = 0
    return b



def noR_v2(a):
    """
    Version de noR utilisant directement la syntaxe numpy
    pour mettre chaque composante rouge à 0.
    Attention, ça prendra autant de temps, même si on n'a écrit
    qu'une ligne, il y a bien une boucle coûteuse cachée derrière !
    """
    b = a.copy()
    n, m, k = a.shape
    b[:, :, 0] = 0
    return b


def negatif(a):
    return 255-a

def permute_couleur(a):
    b = a.copy()
    b[:, :, 0] = a[:, :, 2] # bleu devient rouge
    b[:, :, 2] = a[:, :, 1] # vert devient bleu
    b[:, :, 1] = a[:, :, 0] # rouge devient vert
    return b

def niv_gris(a):
    a_16 = np.int16(a)

    # moyenne: matrice dont chaque case (i, j) contient
    # la moyenne des trois couleurs du pixel (i, j) dans a
    moyenne = (a_16[:,:,0] + a_16[:,:,1] + a_16[:,:,2])/3

    # calcul du résultat final en entier 8 bit non signé
    n, m, k = a.shape
    res = a.copy()
    for i in range(n):
        for j in range(m):
            res[i,j] = np.uint8([moyenne[i,j], moyenne[i,j], moyenne[i,j]])
    return res



def niv_gris_709(a):
    a_16 = np.int16(a)
    moyenne = 0.2126 * a_16[:,:,0] + 0.7152 * a_16[:,:,1] + 0.0722 * a_16[:,:,2]
    n, m, k = a.shape
    res = a.copy()
    for i in range(n):
        for j in range(m):
            res[i,j] = np.uint8([moyenne[i,j], moyenne[i,j], moyenne[i,j]])
    return res


def test_q1_q5_image(filename):
    """
    Teste les fonctions des question 1 à 5 sur l'image du fichier filename
    """
    a = plt.imread(filename)

    b = noR(a)
    plt.imsave(f"resultats/{filename}_sans_rouge.jpg",b)

    b = negatif(a)
    plt.imsave(f"resultats/{filename}_negatif.jpg",b)

    b = permute_couleur(a)
    plt.imsave(f"resultats/{filename}_permuté.jpg",b)

    b = niv_gris(a)
    plt.imsave(f"resultats/{filename}_gris.jpg",b)

    b = niv_gris_709(a)
    plt.imsave(f"resultats/{filename}_gris_709.jpg",b)


# TEST
def test_q1_q5():
    test_q1_q5_image("poivrons.jpg")
    test_q1_q5_image("italie.jpg")
    test_q1_q5_image("paysage_fleur.jpg")


## Palette

def distance_pixel(p, q):
    """
    carré de la distance euclidienne entre p et q
    """
    x = np.int64(p)-np.int64(q)
    return sum(x*x)

def plus_proche_couleur(palette, p):
    """
    renvoie la couleur de `palette` la plus proche de p
    """
    res = palette[0]
    dist_min = distance_pixel(palette[0], p)
    for q in palette:
        dist = distance_pixel(q, p)
        if dist < dist_min:
            res = q
            dist_min = dist
    return res


def reduction_palette(palette, a):
    """
    Renvoie une copie de a où chaque pixel a été remplacé par la couleur
    la plus proche de `palette`
    """
    b = a.copy()
    n,m,k = a.shape

    for i in range(n):
        print(f"{i}/{n} lignes traitées")
        for j in range(m):
            red, green, blue = a[i, j]
            b[i, j] = plus_proche_couleur(palette, b[i, j])
    return b


def test_palette():
""" test: prend environ 20 minutes pour tout exécuter (sur mon ordinateur lent)
"""
    # palette basique: toutes les combinaisons rgb dont les valeurs sont dans [0, 128, 255]
    palette_simple = [
        np.uint8([r, g, b]) for r in [0, 128, 255] for g in [0, 128, 255] for b in [0, 128, 255]
    ]

    # palette pastel: générée avec l'aide de ChatGPT, en lui demandant deux
    # palettes de tons pastels, une plutôt claire et une plutôt sombre.
    light_colors = [(251, 215, 195), # Peach Puff
                    (243, 234, 199), # Lemon Chiffon
                    (192, 238, 224), # Aquamarine
                    (222, 217, 246), # Lavender Mist
                    (231, 191, 221), # Thistle
                    (233, 221, 208), # Almond
                    (243, 195, 198), # Pink Lace
                    (191, 222, 249), # Light Blue
                    (217, 238, 193), # Tea Green
                    (247, 203, 209)] # Light Coral
    dark_colors = [(169, 115, 102), # Copper Red
                (143, 135, 103), # Olive Drab
                (57, 129, 133),  # Pine Green
                (108, 90, 132),  # Purple Heart
                (118, 76, 103),  # Fuzzy Wuzzy Brown
                (135, 109, 82),  # Shadow
                (145, 61, 68),   # Big Dip O’ruby
                (75, 105, 150),  # Steel Blue
                (134, 145, 59),  # Olive Green
                (175, 77, 83)]   # Cinnabar
    palette_pastel = light_colors + dark_colors


    # palette rétro: idem, générée avec l'aide de ChatGPT
    palette_retro = [
        (255, 187, 0),  # Mustard Yellow
        (252, 58, 73),  # Coral Red
        (83, 71, 103),  # Lavender Gray
        (129, 212, 250),  # Baby Blue
        (218, 247, 166),  # Light Pistachio
        (242, 129, 122),  # Coral Pink
        (196, 131, 116),  # Dusty Rose
        (229, 96, 89),  # Watermelon Red
        (246, 187, 110),  # Peachy Yellow
        (185, 107, 104),  # Brick Red
        (143, 158, 159),  # Grayish Blue
        (197, 150, 212),  # Lilac
        (119, 130, 107),  # Olive Green
        (255, 174, 66),  # Bright Orange
        (187, 234, 232),  # Light Blue-Green
        (197, 212, 71),  # Lime Green
        (200, 118, 157),  # Mauve
        (239, 192, 80),  # Sunflower Yellow
        (100, 135, 109),  # Dark Olive
        (227, 104, 174),  # Fuchsia Pink
    ]

    # test des 3 palettes sur les 3 fichiers
    for filename in ["poivrons.jpg", "italie.jpg", "paysage_fleur.jpg"]:
        a = plt.imread(filename)
        b = reduction_palette(palette_simple, a)
        plt.imsave(f"resultats/palettes/{filename}_reduc_simple.jpg", b)

        b = reduction_palette(palette_pastel, a)
        plt.imsave(f"resultats/palettes/{filename}_reduc_pastel.jpg", b)

        b = reduction_palette(palette_retro, a)
        plt.imsave(f"resultats/palettes/{filename}_reduc_retro.jpg", b)





## Transformations globales

def sym_vert(a):
    """
    Renvoie une copie de b ayant subi une symétrie verticale (selon l'axe horizontal médian)
    """
    b = a.copy()
    n, m, k = a.shape
    # échanger chaque ligne i avec la ligne (n-i-1)
    for i in range(n):
        b[i] = a[n-i-1]
    return b

def sym_hori(a):
    """
    Renvoie une copie de b ayant subi une symétrie horizontale (selon l'axe vertical médian)
    """
    b = a.copy()
    n, m, k = a.shape
    # échanger chaque colonne j avec la colonne (n-j-1)
    for j in range(m):
        b[:, j] = a[:, m-j-1]
    return b


def rotation_droite(a):
    """
    renvoie une copie de a ayant subi une rotation de 90 degrés dans le sens
    horaire.

    Image de départ:

    (0  , 0) (0  , 1) .... (0  , m-1)

    (1  , 0) (1  , 1) .... (1  , m-1)

    .....             ....

    (n-1, 0) (n-1, 1) .... (n-1, m-1)

    Image d'arrivée:

    (0  , 0) (0  , 1) .... (0  , n-1)

    (1  , 0) (1  , 1) .... (1  , n-1)

    .....             ....

    (m-1, 0) (m-1, 1) .... (m-1, n-1)

    (la rotation a échangé l'ordre de n et m)

    le pixel (0  , n-1) de l'image d'arrivée est le pixel (0  , 0  ) de l'image de départ.
    le pixel (m-1, n-1) de l'image d'arrivée est le pixel (0  , m-1) de l'image de départ.

    De manière générale, le pixel (i, j) de l'image de départ est
    - à j cases du bord gauche
    - à i cases du bord haut
    il se retrouve ainsi dans l'image d'arrivée (après rotation):
    - à j cases du bord haut
    - à i cases du bord droit

    autrement dit, on applique la transformation (i, j) -> (j, n-1-i)
    """

    n, m, k = a.shape
    b = np.zeros((m, n, k)) # matrice de dimensions m x n x k nulle
    for i in range(n):
        for j in range(m):
            b[j, n-i-1] = a[i, j]
    return np.uint8(b) # reconvertir en entiers 8 bits



def anneaux_concentriques(a, R):
    """
    En mettant les conditions de l'énoncé au carré, on obtient des formules
    plus faciles à programmer:

    - si 0     <= d^2 <   R^2 on laisse le pixel intact
    - si   R^2 <= d^2 < 2 R^2 on inverse le pixel
    - si 2 R^2 <= d^2 < 3 R^2 on inverse le pixel
    - si 3 R^2 <= d^2 < 4 R^2 on inverse le pixel
    - etc...
    Autrement, on regarde le rapport entre d^2 et R^2, et on vérifie si
    sa partie entière est un entier pair ou impair !
    """
    Rsquare = R*R
    (n, m, k) = a.shape
    b = a.copy()
    for i in range(n):
        for j in range(m):
            # distance au carré
            dsquare = (i-n/2)**2 + (j-m/2)**2
            t = int(dsquare/(Rsquare))
            if t % 2:
                b[i, j] = a[i, j]
            else:
                b[i, j] = 255 - a[i, j]
    return b

def coordonnees_photomaton(i, j, n, m):
    """
    Renvoie les coordonnées auxquelles sont envoyées
    le pixel (i, j) lors de la transformation du photomaton
    d'une image de dimensions n x m
    """
    if i % 2 == 0:
        ii = i//2
    else:
        ii = i//2 + n//2
    if j % 2 == 0:
        jj = j//2
    else:
        jj = j//2 + m//2
    return ii, jj

def photomaton(a):
    """
    Applique la transformation du photomaton à a
    """
    (n, m, k) = a.shape
    b = a.copy()
    for i in range(n):
        for j in range(m):
            ii, jj = transfo_photomaton(i, j, n, m)
            b[ii, jj] = a[i, j]
    return b


def test_partie2():
    a = plt.imread("poivrons.jpg")

    b = sym_vert(a)
    plt.imsave("resultats/transformations/poivrons_sym_vert.jpg", b)

    b = sym_hori(a)
    plt.imsave("resultats/transformations/poivrons_sym_hori.jpg", b)

    b = rotation_droite(a)
    plt.imsave("resultats/transformations/poivrons_rotation.jpg", b)

    b = anneaux_concentriques(a, 100)
    plt.imsave("resultats/transformations/poivrons_anneaux.jpg", b)

    b = photomaton(a)
    plt.imsave("resultats/transformations/poivrons_photomaton.jpg", b)

    b = photomaton(b)
    plt.imsave("resultats/transformations/poivrons_double_photomaton.jpg", b)






