

(* appliquer x f renvoie f(x) *)
let appliquer (x: 'a) (f: 'a -> 'b) : 'b =
	f x

(* appliquer 0 est la fonction
   qui à f associe f(0) *)

(* first p renvoie la première composante de p *)
let first ((x, y): 'a * 'b) : 'a =
	x


(* La fonction flip doit prendre en entrée
une fonction à deux arguments, donc de type
'a -> 'b -> 'c', et en faire une fonction
de type 'b -> 'a -> 'c. Donc, son type est:
('a -> 'b -> 'c') -> ('b -> 'a -> 'c) *)

(* flip f renvoie f où l'ordre des arguments
   a été renversé *)
let flip (f: 'a -> 'b -> 'c) : 'b -> 'a -> 'c =
	
	let f_inversee (x: 'b) (y: 'a) : 'c = 
		f y x 
	in
	f_inversee

let plus_deux (x: int) : int =
	let y = x + 1 in
	y + x

(* autre possibilité: *)
let flip2 f x y =
	f y x
(* On a bien que flip2 f est une fonction
   qui attend deux paramètres x et y, et
   renvoie f y x. *)

(* Un petit test *)
let f x y =
	x - y

let g = flip f

let a = g 3 10 (* doit valoir 10 - 3 = 7 *)

