

(* Renvoie le nombre de racines réelles
   distinctes de aX² + bX + c *)
let n_roots (a: float) (b: float) (c: float) : int =
	let delta = b *. b -. 4. *. a *. c in
	if delta > 0. then 2
	else if delta < 0. then 0
	else 1

(* ... *)
let cas_ABC (n: int) : string =
	let reste3 = n mod 3 in
	let reste5 = n mod 5 in
	match (reste3, reste5) with 
	| (0, _) -> "A" 
	| (_, 0) -> "B"
	| _      -> "C"

let g x y = match (x-y, x+y) with
	|  0, _ -> 0
	|  _, 0 -> 0
	|  1, z -> z*z + 1 (* z vaut x+y *)
	| -1, z -> z*z + 1
	|  z, 1 -> z*z - 1
	|  z, -1 -> z*z - 1
	| _ -> x*y