(* Salue prenom *)
let saluer (prenom: string) : unit =
	print_string "Bonjour, ";
	print_string prenom;
	print_endline " !"


(* Renvoie le nombre de racines réelles
   distinctes de aX² + bX + c *)
let n_roots (a: float) (b: float) (c: float) : int =
	let delta = b *. b -. 4. *. a *. c in
	if delta > 0. then 2
	else if delta < 0. then 0
	else 1

(* ... *)
let cas_ABC (n: int) : string =
	match (n mod 3, n mod 5) with 
	| (0, _) -> "A" 
	| (_, 0) -> "B"
	| _      -> "C"



let test_n_roots () =
	(* X² - 2X a deux racines *)
	assert (n_roots 1. (-2.) 0. = 2);

	(* 3X² + 2X + 10 ,n'a pas de racine réelle *)
	assert (n_roots 3. (2.) 10. = 0);

	(* X² - 2X + 1 a une racine *)
	assert (n_roots 1. (-2.) 1. = 1);

	print_endline "Fin des tests de n_roots"

let test_cas_ABC () =
	assert (cas_ABC 7 = "C");
	assert (cas_ABC 3 = "A");
	assert (cas_ABC 15 = "A");
	assert (cas_ABC 200 = "B");
	print_endline "Fin des tests de cas_ABC"
