


(* prod x n renvoie n fois x.
   Hypothèse: n >= 0 *)
let rec prod (x: float) (n: int) : float =
	if n = 0 then 0.
	else prod x (n-1) +. x


let test_prod () =
	assert (prod 0.5 7 = 3.5);
	assert (prod (-2.25) 2 = -4.5);
	print_endline "Fin des tests prod"

(* Renvoie le couple (q, r) de la division
   euclidienne de a par b.
   Hypothèses: a >= 0, b > 0 *)
let rec div_eucl (a: int) (b: int) : (int * int) =
	if a < b then (0, a) else
	let (q, r) = div_eucl (a-b) b in
	(q+1, r)

let test_div_eucl () =
	assert (div_eucl 13 5 = (2, 3));
	assert (div_eucl 91 1 = (91, 0));
	assert (div_eucl 2 15 = (0, 2));
	print_endline "Fin des tests div_eucl"

(* Affiche les chiffres de n ligne par ligne. *)
let rec decomp (n: int) : unit =
	if n < 10 then (
		print_int n;
		print_endline ""
	) else (
		decomp (n/10);
		print_int (n mod 10);
		print_endline ""
	)

(* Comme decomp est de type unit, on ne peut pas
   la tester avec des assertions... *)
let test_decomp () =
	print_endline "Décomposition de 74693:";
	decomp 74693;
	print_endline "Décomposition de 19852151:";
	decomp 19852151;
	print_endline "Fin des tests decomp"

(* Renvoie le n-ème terme de fibonacci
   en prenant u_0 = a, u_1 = b *)
let rec fibo (a: int) (b: int) (n: int) : int =
	if n = 0 then a else 
	(* prendre le n-ème terme de u_0, u_1, ...
	   revient à prendre le (n-1)-ème terme 
	   de u_1, u_2, ....
	   Or, on a u_2 = u_0 + u_1 = a+b: *)
	fibo b (a+b) (n-1)

let test_fibo () =
	assert (fibo 0 1 10 = 55);
	assert (fibo 0 1 30 = 832040);
	assert (fibo 0 0 5000 = 0);
	print_endline "Fin des tests fibo"


let tests () =
	test_prod ();
	test_div_eucl ();
	test_decomp ();
	test_fibo ();
	print_endline "Fin de tous les tests: aucune erreur"