(* somme l renvoie la somme des éléments de l *)
let rec somme (l: int list) : int =
	match l with
	| [] -> 0
	| x :: q -> x + somme q

let test_somme () =
	assert (somme [] = 0);
	assert (somme [1;2;3;4] = 10);
	print_endline "Fin des tests somme"

(* recherche l x renvoie true si x est dans l, false sinon. *)
let rec recherche (l: 'a list) (x: 'a) : bool =
	match l with
	| [] -> false 
	| a :: q -> x = a || recherche q x

let test_recherche () =
	assert (recherche [2; 3; 1; 6; 4; 45; 1; 8; 7] 45);
	assert (not (recherche [] 7));
	assert (not (recherche [1; 6; 3; 48; 8; 1] 7));
	print_endline "Fin des tests recherche"

(* n_eme l i renvoie le i-ème élément de l,
   en comptant à partir de 0 *)
let rec n_eme (l: 'a list) (i: int) : 'a =
	match l, i with
	(* 0-ème élément = tête *)
	| x :: q, 0 -> x
	| x :: q, _ -> n_eme q (i-1)
	(* si la liste est vide, erreur d'indice  *)
	| _ -> failwith "Indice invalide"


let test_n_eme () =
	assert (n_eme ["A"; "B"; "C"] 2 = "C");
	assert (n_eme ["A"; "B"; "C"; "D"] 1 = "B");
	print_endline "Fin des tests n_eme"

let rec filter (f: 'a -> bool) (l: 'a list) : 'a list =
	match l with 
	| [] -> []
	| x :: q ->
		(* On calcule filter f q, puis on rajoute
		   x ou non, selon s'il vérifie f ou pas *)
		if f x then
			x :: filter f q (* comme x :: (filter f q) *)
		else
			filter f q

let test_filter () =
	let est_pair n = 
		n mod 2 = 0
	in
	assert (filter est_pair [3;1;4;1;5;9;2;6] = [4; 2; 6]);
	assert (filter (fun x -> false) [3;1;4;1;5;9;2;6] = []);
	print_endline "Fin des tests filter"


let rec concatener (l1: 'a list) (l2: 'a list) : 'a list =
	match l1 with 
	| [] -> l2
	| x :: q -> 
		(* le premier élément du résultat est x,
		   et il reste à mettre les éléments de q et ceux de l2,
		   ce qui permet d'utiliser concaténer récursivement: *)
		x :: concatener q l2

let test_concatener () =
	assert (concatener [1; 2; 3] [4; 5; 6] = [1; 2; 3; 4; 5; 6]);
	assert (concatener [1;2;3] [] = [1;2;3]);
	print_endline "Fin des tests concatener"

let rec multi_concat (l: 'a list list) : 'a list =
	match l with 
	| [] -> [] (* aucune liste: aucune élément *)
	| l1 :: q -> 
		(* l1 est une liste, q une liste de listes *)
		let elems_de_q = multi_concat q in
		concatener l1 elems_de_q

let test_multi_concat () =
	assert (multi_concat [[]; [1; 2]; []; [3]; [4;5;6]] = [1; 2; 3; 4; 5; 6]);
	print_endline "Fin des tests multi_concat"

let rec map (f: 'a -> 'b) (l: 'a list): 'b list =
	match l with 
	| [] -> []
	| x :: q -> f x :: map f q (* comme (f x) :: (map f q) *)

let test_map () =
	let f x = x*x in
	assert (map f [1;2;3] = [1;4;9]);
	print_endline "Fin des tests map"

let tests () =
	test_somme ();
	test_recherche ();
	test_n_eme ();
	test_filter ();
	test_concatener ();
	test_multi_concat ();
	test_map ();
	print_endline "Fin de tous les tests: pas d'erreur"