



let rec string_cat (l: string list) : string =
	match l with
	| [] -> ""
	| x :: q -> x ^ string_cat q

let test_string_cat () =
	assert (string_cat ["bon"; "jour"; " "; "les"; " "; "MPSI"] = "bonjour les MPSI");
	print_endline "Fin des tests string_cat"


let rec fold (f: 'a -> 'b -> 'b) (l: 'a list) (b: 'b) : 'b =
	match l with
	| [] -> b 
	| x :: q -> f x (fold f q b)

(* 
Lorsque l'on veut écrire une fonction g sur les listes 
sous la forme fold f l b, on doit avoir:
- b est le résultat attendu pour une liste vide, i.e. g []
- f est une fonction à deux arguments, telle que
  si l = x :: q, en notant r le résultat attendu sur
  q, i.e. g [], alors f x r doit être le résultat attendu
  pour l.

Par exemple, pour la fonction taille:
- le résultat attendu pour [] est 0
- si l = x :: q, et que q est de taille r,
  alors l est de taille r + 1, d'où
  f x r = r + 1
Donc:
*)

let taille (l: 'a list) : int =
	fold (fun x r -> r + 1) l 0

let test_taille () =
	assert (taille [] = 0);
	assert (taille [1;2;3;4] = 4);
	print_endline "Fin des tests taille"

(* 
Pour recherche l a:
- si l = [], le résultat est false
- si l = x :: q, et que r est un booléen
  indiquant si a apparaît dans q, alors
  a apparaît dans l si et seulement si
  x = a OU r est vrai *)
let recherche (l: 'a list) (a: 'a) : bool =
	fold (fun x r -> x = a || r) l false

let test_recherche () =
	assert (recherche [2; 3; 1; 6; 4; 45; 1; 8; 7] 45);
	assert (not (recherche [] 7));
	assert (not (recherche [1; 6; 3; 48; 8; 1] 7));
	print_endline "Fin des tests recherche"

(* 
Pour filter f l:
- si l = [], le résultat attendu est []
- si l = x :: q, et que r est la liste
  obtenue en ayant filtré q, alors le 
  résultat est x :: r si x vérifie f,
  et juste r si x ne vérifie pas f *)
let filter (f: 'a -> bool) (l: 'a list) : 'a list =
	let g x r =
		if f x then x :: r else r
	in
	fold g l []

let test_filter () =
	let est_pair n = 
		n mod 2 = 0
	in
	assert (filter est_pair [3;1;4;1;5;9;2;6] = [4; 2; 6]);
	assert (filter (fun x -> false) [3;1;4;1;5;9;2;6] = []);
	print_endline "Fin des tests filter"

(* Même raisonnement pour map *)
let map (f: 'a -> 'b) (l: 'a list) : 'b list =
	fold (fun x r -> f x :: r) l []


let test_map () =
	let f x = x*x in
	assert (map f [1;2;3] = [1;4;9]);
	print_endline "Fin des tests map"


(*
On ne peut pas coder directement la fonction range,
il faut passer par une fonction auxiliaire, par exemple:
*)

(* range_from k n renvoie [k; k+1; ...; n-1],
   ou bien [] si k >= n *)
let rec range_from (k: int) (n: int) : int list =
	if k >= n then [] else
	k :: range_from (k+1) n

(* range n renvoie [0; 1; ...; n-1] *)
let range (n: int) : int list = range_from 0 n

let test_range () =
	assert (range 5 = [0;1;2;3;4]);
	assert (range 0 = []);
	print_endline "Fin des tests range"


let somme_carres_div (n: int) : int =
	(* [0; 1; ...; n-1] *)
	let l = range n in
	(* [1; 2; ...; n] *)
	let l = map (fun x -> x + 1) l in
	(* garder seulement les diviseurs de n *)
	let l = filter (fun x -> n mod x = 0) l in
	(* mettre tout au carré *)
	let l = map (fun x -> x*x) l in
	(* faire la somme *)
	fold (fun x r -> x+r) l 0

let test_somme_carres_div () =
	(* n = 6: 1² + 2² + 3² + 6² = 50 *)
	assert (somme_carres_div 6 = 50);
	(* n = 7: 1² + 7² = 50 *)
	assert (somme_carres_div 7 = 50);
	print_endline "Fin des tests somme_carres_div"


let tests () =
	test_string_cat ();
	test_taille ();
	test_recherche ();
	test_filter ();
	test_map ();
	test_range ();
	test_somme_carres_div ();
	print_endline "Fin de tous les tests: pas d'erreur"