#include "tri_aretes.h"
#include "union_find.h"

void remplit_tableau_aretes(arete_t* arete_arr, city_node_t *noeuds, int n){
    int count = 0; 
    for (int i = 0; i < n; i++){
        for (int j = i+1; j < n; j++){
            arete_t a; 
            a.ID_1 = i;
            a.ID_2 = j;
            a.poids = distance(noeuds[i], noeuds[j]);
            arete_arr[count] = a; 
            count++; 
        }
    }
}

// -------------------- MSP computation -------------------- //
arete_t *kruskal(city_node_t *noeuds, unsigned int n)
{
    int m = (n*(n-1)/2); // nombre d'arêtes
    arete_t* B = malloc((n-1) * sizeof(arete_t)); // arbre couvrant
    arete_t* arete_arr = malloc(m*sizeof(arete_t)); //Stocke toutes les arêtes
    remplit_tableau_aretes(arete_arr, noeuds, n); 
    tri_en_place(arete_arr, m); 
    union_find u = uf_creer(n);
    int i = 0; // indice de l'arête en cours
    int taille_arbre = 0; 
    while (taille_arbre < n-1){
        arete_t a = arete_arr[i];
        if (uf_find(u, a.ID_1) != uf_find(u, a.ID_2)){
            uf_union(u, a.ID_1, a.ID_2); 
            B[taille_arbre] = a;
            taille_arbre ++;
        }
        i++;
    }
    uf_supprime(u);
    free(arete_arr);
    return B;
}
