#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tri_aretes.h" 

// Fonction d'affichage
static void print_aretes(arete_t *arr, unsigned n) {
    for (unsigned i = 0; i < n; i++) {
        printf("(%u, %u) w=%.2f\n", arr[i].ID_1, arr[i].ID_2, arr[i].poids);
    }
    printf("\n");
}

static int check_sorted(arete_t *arr, unsigned n) {
    for (unsigned i = 1; i < n; i++) {
        if (arr[i].poids < arr[i - 1].poids)
            return 0;
    }
    return 1;
}

int main(void) {

    printf("=== TEST tri_en_place ===\n\n");

    // -------------------------
    // Test principal
    // -------------------------
    arete_t arr[] = {
        {0, 1, 5.4},
        {2, 3, 1.2},
        {1, 4, 3.8},
        {4, 5, 0.9},
        {3, 2, 9.1},
        {9, 0, 3.8}
    };

    unsigned n = sizeof(arr) / sizeof(arr[0]);

    printf("Tableau avant tri :\n");
    print_aretes(arr, n);

    tri_en_place(arr, n);

    printf("Tableau après tri :\n");
    print_aretes(arr, n);

    assert(check_sorted(arr, n));
    printf(" Tri correct\n\n");

    // -------------------------
    // Test 1 : tableau taille 1
    // -------------------------
    arete_t t1[] = {{1, 2, 4.2}};
    tri_en_place(t1, 1);
    assert(check_sorted(t1, 1));
    printf(" Cas taille 1 OK\n");

    // -------------------------
    // Test 2 : tableau déjà trié
    // -------------------------
    arete_t t2[] = {
        {1, 2, 0.1},
        {3, 4, 1.5},
        {5, 6, 2.7},
    };
    tri_en_place(t2, 3);
    assert(check_sorted(t2, 3));
    printf(" Cas déjà trié OK\n");

    // -------------------------
    // Test 3 : tableau trié à l’envers
    // -------------------------
    arete_t t3[] = {
        {1, 2, 9.0},
        {3, 4, 6.0},
        {5, 6, 3.0},
        {7, 8, 1.0}
    };
    tri_en_place(t3, 4);
    assert(check_sorted(t3, 4));
    printf(" Cas inversé OK\n");

    // -------------------------
    // Test 4 : doublons de poids
    // -------------------------
    arete_t t4[] = {
        {1, 2, 2.0},
        {3, 4, 2.0},
        {5, 6, 1.0},
        {7, 8, 1.0}
    };
    tri_en_place(t4, 4);
    assert(check_sorted(t4, 4));

    printf("🎉 Tous les tests PASSÉS avec succès !\n");
    return 0;
}
