#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "union_find.h"

// Fonction d'affichage
static void print_uf(union_find u) {
    printf("UF state:\n");
    for (int i = 0; i < u->taille; i++) {
        printf("  pere[%d] = %d\n", i, u->pere[i]);
    }
    printf("\n");
}

int main(void) {

    printf("=== TEST UNION FIND ===\n");

    union_find u = uf_creer(5);
    if (!u) {
        printf("Erreur : impossible de créer l'union-find\n");
        return 1;
    }

    printf("UF créé avec 5 éléments.\n");
    print_uf(u);

    // --- Test find sur structure fraîche ---
    printf("Test Find : chaque élément est son propre parent...\n");
    for (int i = 0; i < 5; i++) {
        int r = uf_find(u, i);
        printf("find(%d) = %d\n", i, r);
        assert(r == i);
    }
    printf("OK\n\n");

    // --- Test union ---
    printf("Union 0 et 1\n");
    uf_union(u, 0, 1);
    print_uf(u);
    assert(uf_find(u, 0) == uf_find(u, 1));

    printf("Union 3 et 4\n");
    uf_union(u, 3, 4);
    print_uf(u);
    assert(uf_find(u, 3) == uf_find(u, 4));

    printf("Union 1 et 4 (donc 0,1,3,4 ensemble)\n");
    uf_union(u, 1, 4);
    print_uf(u);
    int r014 = uf_find(u, 0);
    assert(uf_find(u, 1) == r014);
    assert(uf_find(u, 3) == r014);
    assert(uf_find(u, 4) == r014);

    // --- Vérification d'un élément seul ---
    printf("Test que 2 n'est relié à personne\n");
    assert(uf_find(u, 2) == 2);
    printf("OK\n\n");

    // --- Test final ---
    printf("Tous les tests PASSÉS avec succès !\n");

    uf_supprime(u);
    printf("Union-find supprimé.\n");

    return 0;
}
