#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "city_graph.h"
#include "city_parser.h"
#include "arbre_couvrant.h"
#include "geojson_producer.h"

// ----- Point d'entrée du programme ----- //

static void print_help(char *prog_name)
{
    printf("TP11 -- Arbre couvrant\n\n");
    printf("Usage:\n%s villes.csv output.geojson\n\n", prog_name);
    printf(
        "Calcule l'arbre couvrant de poids minimal sur le graphe geometrique\n"
        "des villes donnee en entree. Par defaut, utilise l'algorithme de Kruskal.\n\n"
        "Arguments:\n"
        "\t villes.csv     : Fichier a lire pour recuperer la listes des villes.\n"
        "\t output.geojson : Fichier dans lequel ecrire le resultat (liste des villes\n"
        "\t                  et liste des aretes).\n");
}

int main(int argc, char *argv[])
{
    if (argc != 3){
        print_help(argv[0]); 
        return 0; 
    }
    FILE *fichier_entree = fopen(argv[1], "r");
    FILE *fichier_sortie = fopen(argv[2], "w");

    printf("- Parsing ...");

    city_node_t *noeud_array = NULL;
    unsigned nb_noeuds = parse_file(fichier_entree, &noeud_array);

    printf(" Done\n");

    fclose(fichier_entree);

    printf("- Computing using ");

    arete_t *arbre_couvrant = kruskal(noeud_array, nb_noeuds);


    printf(" ... Done\n");
    printf("-> Cout de l'arbre: %f\n", cout_arbre(arbre_couvrant, nb_noeuds - 1));

    printf("- Dumping results in ");

    dump_nodes_and_aretes(fichier_sortie,
                         noeud_array, nb_noeuds,
                         arbre_couvrant, nb_noeuds - 1);

    fclose(fichier_sortie);

    printf(" Done!\n");

    for (size_t i = 0; i < nb_noeuds; i++)
    {
        delete (&noeud_array[i]);
    }
    free(noeud_array);
    free(arbre_couvrant);

    return 0;
}
