#include "arbre_decision.h"
#include <stdlib.h>
#include <stdio.h>

void affiche_arbre_aux(darbre da, char *prefixe, int l, int lrn) {
  /* Fonction auxiliaire récursive pour l'affichage d'un arbre.
     Affiche le sous-arbre da, qui est :
     - la racine si lrn == 2
     - un fils gauche si lrn == 0
     - un fils droit si lrn == 1.
     Chaque ligne d'affichage est précédée du préfixe prefixe de longueur
     l.
  */
  if (da->classe >= 0) {
    if (lrn == 0) { /* fils gauche */
      printf("%s├─ : %d\n", prefixe, da->classe);
    } else if (lrn == 1) { /* fils droit */
      printf("%s└─ : %d\n", prefixe, da->classe);
    } else { /* racine */
      printf("%s%d\n", prefixe, da->classe);
    }
  } else {
    if (lrn == 0) { /* fils gauche */
      printf("%s├─%d\n", prefixe, da->i);
    } else if (lrn == 1) { /* fils droit */
      printf("%s└─%d\n", prefixe, da->i);
    } else { /* racine */
      printf("%s%d\n", prefixe, da->i);
    }
    int new_l = l;  /* racine */
    if (lrn == 0) { /* fils gauche */
      strcat(prefixe, "│ ");
      new_l = l + 4;
    } else if (lrn == 1) { /* fils droit */
      strcat(prefixe, "  ");
      new_l = l + 2;
    }
    affiche_arbre_aux(da->faux, prefixe, new_l, 0);
    affiche_arbre_aux(da->vrai, prefixe, new_l, 1);
    prefixe[l] = '\0';
  }
}

void affiche_arbre(darbre da) {
  /* Affiche l'arbre da */
  char prefixe[101];
  prefixe[0] = '\0';
  affiche_arbre_aux(da, prefixe, 0, 2);
}