#ifndef _ARBRE_DECISION_H
#define _ARBRE_DECISION_H

#include <stdbool.h>

/********************************
 *     Définition des types     *
 ********************************/

// Type des arbres de décision 
struct darbre_noeud_s {
    int classe; /* la classe ou -1 si noeud interne */
    int i;  /* la coordonnée de disjonction */
    struct darbre_noeud_s *faux; /* le fils gauche */
    struct darbre_noeud_s *vrai; /* le fils droit */
};
typedef struct darbre_noeud_s *darbre; /* Un arbre est un pointeur vers sa racine */

// Type des données 
struct donnee_c {
    bool* contenu; /* un tableau de booléens */
    int d; /* la taille du tableau contenu */
    int classe; /* la classe de la donnée, -1 si non définie */
};
typedef struct donnee_c donnee_c;

/********************************
 *  Déclaration des fonctions   *
 ********************************/

// fonction d'affichage d'un arbre 
void affiche_arbre(darbre da);

// fonction de création d'une feuille 
darbre cree_feuille(int classe); 

// fonction de création d'un arbre avec noeud et fils 
darbre cree_noeud(int i, darbre faux, darbre vrai); 

// fonction qui teste si un arbre est une feuille
bool est_feuille(darbre da); 

// fonction qui attribue une classe à la donnée d selon l'arbre de décision da
void lit_darbre(darbre da, donnee_c* d);

void libere_darbre(darbre da); 
#endif
