#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include "arbre_decision.h"

int main() {
    // --- Création des feuilles ---
    darbre f0 = cree_feuille(0);
    darbre f1 = cree_feuille(0);
    darbre f2 = cree_feuille(1);
    darbre f3 = cree_feuille(3);
    darbre f4 = cree_feuille(1);
    darbre f5 = cree_feuille(3);

    // --- Création du sous-arbre gauche ---
    darbre n1 = cree_noeud(0, f0, f1);

    // --- Création du sous-arbre gauche ---
    darbre n2 = cree_noeud(0, f2, f3);
    darbre n3 = cree_noeud(0, f4, f5);
    darbre n4 = cree_noeud(2, n2, n3);

    // --- Création de la racine ---
    darbre racine = cree_noeud(1, n1, n4);

    printf("=== Affichage de l'arbre ===\n");
    affiche_arbre(racine);
    printf("============================\n\n");

    // --- Tests sur les feuilles ---
    assert(est_feuille(f1));
    assert(est_feuille(f0));
    assert(est_feuille(f2));

    // --- Tests sur les noeuds internes ---
    assert(!est_feuille(n1));
    assert(!est_feuille(racine));

    // --- Vérification de la structure ---
    assert(racine->i == 1);
    assert(racine->faux == n1);
    assert(racine->vrai == n4);
    assert(n1->i == 0);
    assert(n1->faux == f0);
    assert(n1->vrai == f1);

    // --- Test de lit_arbre ---
    donnee_c data;
    data.d = 3; 
    data.contenu = malloc(3 * sizeof(bool));
    data.contenu[0] = true; 
    data.contenu[1] = true; 
    data.contenu[2] = false; 
    data.classe = -1; 

    lit_darbre(racine, &data); 

    printf("%d\n", data.classe);
    assert(data.classe == 3); 

    // --- Libération mémoire ---
    libere_darbre(racine);
    free(data.contenu); 

    return 0;
}
