#include "arbre_decision.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

void affiche_arbre_aux(darbre da, char *prefixe, int l, int lrn) {
  /* Fonction auxiliaire récursive pour l'affichage d'un arbre.
     Affiche le sous-arbre da, qui est :
     - la racine si lrn == 2
     - un fils gauche si lrn == 0
     - un fils droit si lrn == 1.
     Chaque ligne d'affichage est précédée du préfixe prefixe de longueur
     l.
  */
  if (da->classe >= 0) {
    if (lrn == 0) { /* fils gauche */
      printf("%s├─ : %d\n", prefixe, da->classe);
    } else if (lrn == 1) { /* fils droit */
      printf("%s└─ : %d\n", prefixe, da->classe);
    } else { /* racine */
      printf("%s%d\n", prefixe, da->classe);
    }
  } else {
    if (lrn == 0) { /* fils gauche */
      printf("%s├─%d\n", prefixe, da->i);
    } else if (lrn == 1) { /* fils droit */
      printf("%s└─%d\n", prefixe, da->i);
    } else { /* racine */
      printf("%s%d\n", prefixe, da->i);
    }
    int new_l = l;  /* racine */
    if (lrn == 0) { /* fils gauche */
      strcat(prefixe, "│ ");
      new_l = l + 4;
    } else if (lrn == 1) { /* fils droit */
      strcat(prefixe, "  ");
      new_l = l + 2;
    }
    affiche_arbre_aux(da->faux, prefixe, new_l, 0);
    affiche_arbre_aux(da->vrai, prefixe, new_l, 1);
    prefixe[l] = '\0';
  }
}

void affiche_arbre(darbre da) {
  /* Affiche l'arbre da */
  char prefixe[101];
  prefixe[0] = '\0';
  affiche_arbre_aux(da, prefixe, 0, 2);
}

darbre cree_feuille(int classe){
  // renvoie un pointeur vers une noeud dans le tas
  darbre feuille = malloc(sizeof(struct darbre_noeud_s));
  // on lui attribue la bonne classe
  feuille->classe = classe; 
  return feuille; 
}

darbre cree_noeud(int i, darbre faux, darbre vrai){
  // renvoie un pointeur vers une noeud dans le tas
  darbre noeud = malloc(sizeof(struct darbre_noeud_s));

  //Initialisation des champs
  noeud->classe = -1; // noeud interne, donc de classe -1
  noeud->i = i; 
  noeud->faux = faux; 
  noeud->vrai = vrai; 
  return noeud; 
}

bool est_feuille(darbre da){
  return da->classe != -1;
}

void libere_darbre(darbre da){
  //Si le pointeur est NULL, rien à faire
  if (da == NULL) return; 

  //Si l'arbre est un noeud interne, on libère ses fils
  if (!est_feuille(da)) {
    libere_darbre(da->faux);
    libere_darbre(da->vrai);
  }
  
  //Libération du noeud da
  free(da); 
}

void lit_darbre(darbre da, donnee_c* d){
  // Si l'arbre est une feuille, on attribue la classe associée
  if (est_feuille(da)) {
    d->classe = da->classe; 
    return; 
  }

  /* Sinon, on cherche récursivement dans le bon sous-arbre
  selon la valeur de la composante de séparation xi */
  bool xi = d->contenu[da->i]; 
  if (xi) {
    lit_darbre(da->vrai, d);
  }
  else {
    lit_darbre(da->faux, d);
  }
}