#include "id3.h"
#include "arbre_decision.h"
#include <math.h>

void complete_profil(jeu_donnees_c jdc, int* profil){
    // Initialisation de profil à 0
    for (int i = 0; i < jdc.K; i++){
        profil[i] = 0;
    }

    //Parcours de jdc avec mise à jour du profil
    for (int d = 0; d < jdc.taille; d++){
        int classe = jdc.donnees[d].classe; 
        profil[classe] = profil[classe] + 1;
    }
}

int jdc_est_uniforme(jeu_donnees_c jdc){
    int* profil = malloc(jdc.K * sizeof(int)); 
    complete_profil(jdc, profil); 
    int classe = -1; 
    for (int i = 0; i < jdc.K; i++){
        if (profil[i] > 0) {
            // Si il y a deux classes 
            if (classe != -1) {
                return -1;
            }
            // Sinon, i devient la classe potentielle
            classe = i; 
        }
    }
    return classe; 
}

double entropie(jeu_donnees_c jdc){
    int* profil = malloc(jdc.K * sizeof(int)); 
    complete_profil(jdc, profil); 
    double h = 0.; 
    for (int i = 0; i < jdc.K; i++){
        int n_i = profil[i];
        if (n_i > 0) {
            h -= log2(n_i/jdc.taille) * n_i/jdc.taille; 
        }
    }
    return h; 
}

void partitionne_jdc(jeu_donnees_c jdc, int i, jeu_donnees_c* jdc_i_faux, jeu_donnees_c* jdc_i_vrai){
    jdc_i_faux = malloc(sizeof(jeu_donnees_c));
    jdc_i_vrai = malloc(sizeof(jeu_donnees_c));

    //On crée deux tableaux de taille jdc.taille pour contenir les données
    jdc_i_faux->donnees = malloc(jdc.taille*sizeof(donnee_c));
    jdc_i_vrai->donnees = malloc(jdc.taille*sizeof(donnee_c));
    
    jdc_i_faux->taille = 0;
    jdc_i_vrai->taille = 0; 

    for (int d = 0; d < jdc.taille; d++){
        donnee_c donnee = jdc.donnees[d]; 
        bool xi = donnee.contenu[i];
        if (xi){
            jdc_i_vrai->donnees[jdc_i_vrai->taille] = donnee;
            jdc_i_vrai->taille += 1; 
        }
        else {
            jdc_i_faux->donnees[jdc_i_faux->taille] = donnee;
            jdc_i_faux->taille += 1; 
        }
    }
}

double gain_entropie_i(jeu_donnees_c jdc, int i){
    double h = entropie(jdc);  

    // On partitionne les données selon i
    jeu_donnees_c jdc_i_faux;
    jeu_donnees_c jdc_i_vrai;
    partitionne_jdc(jdc, i, &jdc_i_faux, &jdc_i_vrai); 

    //On calcule les entropies associées à chaque partie
    double h_vrai = entropie(jdc_i_vrai); 
    double h_faux = entropie(jdc_i_faux);

    //On définit le gain comme vu en cours
    double gain = h - (jdc_i_faux.taille / jdc.taille) * h_faux
                    - (jdc_i_vrai.taille / jdc.taille) * h_vrai;
    return gain; 
}

int gain_max(jeu_donnees_c jdc, bool* utilisees){
    int i_max = -1;
    double gain_max = 0.;
    for (int i = 0; i < jdc.d; i++){
        if (!utilisees[i]) {
            double gain = gain_entropie_i(jdc, i);
            if (gain > gain_max){
                gain_max = gain; 
                i_max = i; 
            }
        }
    } 
    return i_max;
}

bool* copie(bool* tab, int n){
    bool* copie = malloc(n * sizeof(bool)); 
    for (int i = 0; i < n ; i++){
        copie[i] = tab[i]; 
    }    
    return copie; 
}

darbre id3_aux(jeu_donnees_c jdc, bool* utilise){
    int classe_uniforme = jdc_est_uniforme(jdc);
    if (classe_uniforme > 0){
        return cree_feuille(classe_uniforme);
    }
    int i = gain_max(jdc, utilise);
    utilise[i] = true;
    
    // On partitionne les données selon i
    jeu_donnees_c jdc_i_faux;
    jeu_donnees_c jdc_i_vrai;
    partitionne_jdc(jdc, i, &jdc_i_faux, &jdc_i_vrai); 

    // Construction récursive des sous-arbres gauches et droits 
    // Attention : il faut copier le tableau utilise
    darbre faux = id3_aux(jdc_i_faux, copie(utilise, jdc.d));
    darbre vrai = id3_aux(jdc_i_vrai, copie(utilise, jdc.d));

    // Libération mémoire
    free(utilise); 

    // On crée la racine
    return cree_noeud(i, faux, vrai); 
}

darbre id3(jeu_donnees_c jdc){
    bool* utilise = malloc(jdc.d * sizeof(bool)); 
    for (int i = 0; i < jdc.d ; i++){
        utilise[i] = false; 
    }    
    id3_aux(jdc, utilise);
}
