#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include "file.h"

#define N 20
#define INF 1e9

typedef struct {
    int x, y; //coordonées du sommet
    double dist;  // distance connue à la source
    double priorite;  // priorité dans la file
    int pred_x, pred_y; //coordonées du prédecesseur du sommet
} sommet;

// Directions (8 mouvements possibles)
int dx[8] = {-1, 1, 0, 0, -1, -1, 1, 1};
int dy[8] = {0, 0, -1, 1, -1, 1, -1, 1};
double cout[8] = {1, 1, 1, 1, sqrt(2), sqrt(2), sqrt(2), sqrt(2)};


// ===================== Lecture de fichiers =====================

int lire_grille(const char *nom, char grille[N][N], int *s_x, int *s_y, int *t_x, int *t_y) {
    FILE *f = fopen(nom, "r");
    if (!f) return 0;

    char ligne[N+2]; // +2 pour \n et \0
    int n = 0;
    while (n < N && fgets(ligne, sizeof(ligne), f)) {
        for (int j = 0; j < N; j++) {
            if (ligne[j] == '\0' || ligne[j] == '\n') 
                grille[n][j] = '.'; // remplissage par défaut
            else
                grille[n][j] = ligne[j];

            if (grille[n][j] == 'S') { *s_x = n; *s_y = j; }
            if (grille[n][j] == 'T') { *t_x = n; *t_y = j; }
        }
        n++;
    }

    // Si le fichier a moins de N lignes, remplir le reste par '.'
    while (n < N){
        for (int j = 0; j < N; j++)
            grille[n][j] = '.';
        n++;
    }
    fclose(f);
    return 1;
}

// ===================== ALGORITHMES =====================



// ===================== MAIN =====================

int main() {
    char grille[N][N];
    int s_x, s_y, t_x, t_y;

    if (!lire_grille("grille1.txt", grille, &s_x, &s_y, &t_x, &t_y)) {
        printf("Erreur de lecture du fichier.\n");
        return 1;
    }

    printf("=== Grille initiale ===\n");
    affiche(grille);

    printf("\n--- Dijkstra ---\n");
    char copie1[N][N];
    sommet sol1[N][N];
    for (int i = 0; i < N; i++)
        for (int j = 0; j < N; j++)
            copie1[i][j] = grille[i][j];
    dijkstra(copie1, sol1, s_x, s_y, t_x, t_y);
    marque(copie1, sol1);
    chemin(copie1, sol1, s_x, s_y, t_x, t_y);
    affiche(copie1);

    printf("\n--- A* ---\n");
    char copie2[N][N];
    sommet sol2[N][N];
    for (int i = 0; i < N; i++)
        for (int j = 0; j < N; j++)
            copie2[i][j] = grille[i][j];
    astar(copie2, s_x, s_y, t_x, t_y);
    marque(copie2, sol2);
    chemin(copie2, sol2, s_x, s_y, t_x, t_y);
    affiche(copie2);

    return 0;
}
