#include "file.h"

// Échange de deux éléments du tas
static void echanger(element_tas *a, element_tas *b) {
    element_tas tmp = *a;
    *a = *b;
    *b = tmp;
}

// Remonte un élément pour restaurer la propriété de tas
static void entasser_haut(file_p *f, int i) {
    while (i > 0) {
        int parent = (i - 1) / 2;
        if (f->tab[parent].priorite <= f->tab[i].priorite)
            break;
        echanger(&f->tab[parent], &f->tab[i]);
        i = parent;
    }
}

// Redescend un élément pour restaurer la propriété de tas
static void entasser_bas(file_p *f, int i) {
    while (1) {
        int g = 2 * i + 1;
        int d = 2 * i + 2;
        int min = i;

        if (g < f->taille && f->tab[g].priorite < f->tab[min].priorite)
            min = g;
        if (d < f->taille && f->tab[d].priorite < f->tab[min].priorite)
            min = d;
        if (min == i)
            break;
        echanger(&f->tab[i], &f->tab[min]);
        i = min;
    }
}

// Initialise une file vide
file_p * file_vide() {
    file_p *f = malloc(sizeof(file_p)); 
    f->taille = 0;
    return f; 
}

// Teste si la file est vide
int est_vide(file_p *f) {
    return f->taille == 0;
}

// Insertion d’un nouvel élément
void inserer(file_p *f, int x, int y, double priorite) {
    if (f->taille >= MAX_TAILLE) {
        fprintf(stderr, "Erreur : tas plein !\n");
        return;
    }
    f->tab[f->taille].x = x;
    f->tab[f->taille].y = y;
    f->tab[f->taille].priorite = priorite;
    entasser_haut(f, f->taille);
    f->taille++;
}

// Extraction du minimum
element_tas extraire_min(file_p *f) {
    if (f->taille == 0) {
        fprintf(stderr, "Erreur : tas vide !\n");
        element_tas vide = {-1, -1, INFINITY};
        return vide;
    }
    element_tas min = f->tab[0];
    f->taille--;
    f->tab[0] = f->tab[f->taille];
    entasser_bas(f, 0);
    return min;
}

// Mise à jour de la priorité (si déjà présent)
void maj_priorite(file_p *f, int x, int y, double priorite) {
    for (int i = 0; i < f->taille; i++) {
        if (f->tab[i].x == x && f->tab[i].y == y) {
            if (priorite < f->tab[i].priorite) {
                f->tab[i].priorite = priorite;
                entasser_haut(f, i);
            }
            return;
        }
    }
    // Si pas trouvé, on insère
    inserer(f, x, y, priorite);
}
