#ifndef FILE_H
#define FILE_H

#include <stdio.h>
#include <stdlib.h>
#include "math.h"

// Taille max du tas (pour grille 20x20)
#define MAX_TAILLE 400

typedef struct {
    int x, y;           // coordonnées du sommet
    double priorite;    // clé du tas (plus petite priorité = plus prioritaire)
} element_tas;

// File de priorité = tas binaire min
typedef struct {
    element_tas tab[MAX_TAILLE];
    int taille;
} file_p;

// Fonctions du tas
file_p *file_vide();
int est_vide(file_p *f);
void inserer(file_p *f, int x, int y, double priorite);
element_tas extraire_min(file_p *f);
void maj_priorite(file_p *f, int x, int y, double priorite);

#endif