#utilitaires pour theorie des graphes sur le metro parisien
#

#importation des modules usuels
from tkinter import *
from time import *

#initialisations et constantes
r = 6 #rayon des disques representant une station
n = 0 #nombre de stations
Couleurs=["White","Yellow","Blue","Grey","Purple","Orange","LightBlue","Pink","Grey","LightGrey","Brown","chocolate1","DarkGreen","Cyan","Black"]*20
#couleurs des lignes de metro dans leur ordre d'indexation
def RGBConvert(r,g,b) :
    rm, gm, bm = min(r,255),min(g,255),min(b,255)
    code = '#%02x%02x%02x' % (r, g, b)
    return(code)

#L est la liste des stations
#pour chaque station, les elements sont dans l'ordre : nom (string), code (string 4), arrindissement (string), lignes (list of int), abscisse (int), ordonnee (int), successeurs (list of code) 

Fen1 = Tk()
Plan = Canvas(Fen1, width=1020, height=720)
Plan.grid(column=0, row=0)
Fond = PhotoImage(file = 'Plan.gif')
Plan.create_image(0,0,image=Fond,anchor=NW)
Plan.update()
Plan.create_rectangle(700,5,980,35,fill="White")
Info = Plan.create_text(715,20,text='Nom',font='Arial 15',anchor=W)

index = 0
V = []



def VisuMatrice(M,echx=3,echy=2,nom="Matrice") :
    #ouvre une fenetre pour afficher la matrice (carree) du graphe
    #en cliquant on recupere le nom des deux stations et la valeur du terme de la matrice
    N = len(M)
    FVM = Tk()
    FVM.title(nom)
    CVM = Canvas(FVM, width=echx*(N+2),height=echy*(N+2))
    CVM.grid(row=1,column=1)
    TVM = Label(FVM,text="Cliquez sur une case pour connaîtres les stations concernées")
    TVM.grid(row=2,column=1)
    CVM.create_rectangle(echx,echy,echx*(N+2),echy*(N+2),width=echx//2,fill=None)
    def Clic(event) :
        #recuperation des coordonnees du point de clic et affichage des infos
        x,y = int(event.x),int(event.y)
        i, k = y//echy-1,x//echx-1
        depart, arrivee = L[k][0], L[i][0]
        TVM.configure(text=depart+','+arrivee+' : '+str(M[i][k]))
    #affichage des valeurs sous forme de niveau de bleu
    for k in range(N) :
        for i in range(N) :
            x, y, Index = (k+1)*echx, (i+1)*echy, k*N+i
            if M[i][k] > 0 :
                CVM.create_rectangle(x,y,x+echx,y+echy,width=0,fill=RGBConvert(0,0,M[i][k]+50))
    #associaition du clic de sousris a l'action lecture
    CVM.bind("<Button-1>", Clic)
    FVM.update()            
    #FVM.mainloop()



def ClicStation(event) : #detecte la station sur laquelle on a clique sur le graphe Plan
    global V
    x = int(event.x) #lecture de l'evenement
    y = int(event.y)
    LaStation, Trouve = None, False
    for station in L : #exploration de la liste des stations
        xs, ys = station[4], station[5] #coordonnees de la station
        if abs(xs-x)<=r and abs(ys-y) <= r : #proximite avec les coordonnees lues
            LaStation = station
            Trouve = True
    if Trouve :
        Plan.itemconfig(Info,text=LaStation[1]+'*'+LaStation[0])
        V.append(LaStation[1])
    else :
        Plan.itemconfig(Info,text="Essaye encore")
    return(LaStation)

Plan.bind("<Button-1>", ClicStation)


#lecture du fichier
Fic = open('RATP_voisins.txt','r',encoding='latin-1')
L, Dico, Codi, Carres = [], {}, {}, []
#L est la liste des stations
#Carres est la liste des objets Tkinter "carres pour localiser la station
#initialement, ils sont transparents
for ligne in Fic : #on va lire ligne par ligne le fichier texte et en faire des nombres, listes...
    Nom, Code, MotLignes, Arrondissement, Motx, Moty = "", "", "", "", "", ""
    i = 0
    while ligne[i] != ";" :
        Nom += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        Code += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        MotLignes += ligne[i]
        i+=1
    Lignes = []
    for nl in MotLignes.split(',') :
        Lignes.append(int(nl))
    i+=1
    while ligne[i] != ";" :
        Arrondissement += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        Motx += ligne[i]
        i+=1
    x = int(Motx)
    i+=1
    while ligne[i] != ";" :
        Moty += ligne[i]
        i+=1
    y = int(Moty)
    motfin = ligne[i+2:-2].split(',')
    suivants = []
    for st in motfin :
        suivants.append(st[1:-1])
    Plan.itemconfig(Info,text=Nom)
    Carres.append(Plan.create_rectangle(x-10,y-10,x+10,y+10,fill=None,width=0))
    for i in range(len(Lignes)) :
        Plan.create_oval(x+2*i-r,y+2*i-r,x+2*i+r,y+2*i+r,fill=Couleurs[Lignes[i]],width=2*int(i==len(Lignes)-1))
    Plan.update()
    #sleep(0.7)
    L.append([Nom, Code, Arrondissement, Lignes, x, y, suivants])
    Dico[Code]=n
    Codi[n]=Code
    n += 1
Fic.close()


def PointeStation(k, couleur= "Black") :#met en valeur la station k sur Plan ; couleur par defaut "noir"
    #k peut etre un entier ou un code
    index = -1
    if type(k)==int :
        index = k
    if type(k)==str and k in Dico.keys() :
        index = Dico[k]
    if -1<index<n : 
        Plan.itemconfig(Carres[index],fill=couleur)
    else :
        print("Quelle station demandez vous ?")
    Plan.update()

def CreeMatrice() :
    M = [[0 for k in range(n)] for i in range(n)]
    for i in range(n) :
        suiv = L[i][6]
        for s in suiv :
            M[i][Dico[s]]=1
    return(M)

def ProduitMatriciel(A, B) :
    LA, CA, LB, CB = len(A), len(A[0]), len(B), len(B[0])
    C = [[0 for k in range(CB)] for i in range(LA)]
    for i in range(LA) :
        for k in range(CB) :
            for j in range(CA) :
                C[i][k]+=A[i][j]*B[j][k]
    return(C)
         
Incidence = CreeMatrice()


def CompteStations(k) : #int -> int #compte les stations d'une ligne
    c = 0
    for Station in L :
        if k in Station[3] :
            c+=1
    return(c)

Maxi, Memo = 0, [] #recherche de la ligne ayant le plus de stations
for Index in range(30) :
    Valeur = CompteStations(Index)
    print(Index, Valeur)
    if Valeur > Maxi :
        Maxi = Valeur
        Memo = []
    if Valeur == Maxi :
        Memo.append(Index)
print(Memo, Maxi)

#table des correspodances entre lignes
NbL = 80
T = [[False for k in range(NbL)] for i in range(NbL)]
for Station in L :
    Lignes = Station[3]
    for i in Lignes :
        for k in Lignes :
            if i != k :
                T[i][k] = True
NbC = [0 for i in range(NbL)]
for i in range(NbL) :
    for k in range(NbL) :
        if T[i][k] :
            NbC[i] += 1
def Stat(k) :
    LS = []
    for Station in L :
        if k in Station[3] :
            LS.append(Station[0])
    LS.sort()
    return(LS)

Stat(7)



File = ['paul']
Visite={}
Visite['paul'] = [0,'']
while len(File)>0 :
    St = File.pop(0)
    distance = Visite[St][0]
    trajet = Visite[St][1]
    etape = L[Dico[St]][0][:15]
    Plan.itemconfig(Info,text=etape)
    
    PointeStation(St,couleur="Red")
    sleep(2.5)
    for succ in L[Dico[St]][-1] :
        Plan.itemconfig(Info,text=etape+' voisins')
        if not(succ in Visite.keys()) :
            Visite[succ] = [distance+1,trajet+' / '+etape]
            File.append(succ)
            PointeStation(succ,couleur="Green")
    sleep(2.5)
    for succ in L[Dico[St]][-1] :
        PointeStation(succ)
    sleep(1.5)
    PointeStation(St,couleur="Cyan")
for S in Visite.keys() :
    print(L[Dico[S]][0])
    print(Visite[S][0])
    print(Visite[S][1])
    
    print('.')
"""VisuMatrice(Incidence,nom="Matrice du graphe")
print('Et d une')
P = ProduitMatriciel(Incidence,Incidence)
print(P[0])
VisuMatrice(P,nom="Premiere iteration")
PP = ProduitMatriciel(P,Incidence)
VisuMatrice(PP,nom="Deuxieme iteration")
PPP = ProduitMatriciel(PP,Incidence)
VisuMatrice(PPP,nom="Troisieme iteration")
P4 = ProduitMatriciel(PP,PP)
VisuMatrice(P4,nom="Beaucoup")"""

Fen1.mainloop()
